/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.util;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.util.IOUtils;

public class AvroUtils {
    public static Map<String, Schema.Field> getFieldMap(Schema schema) {
        List fields = schema.getFields();
        HashMap<String, Schema.Field> fieldMap = new HashMap<String, Schema.Field>(fields.size());
        for (Schema.Field field : fields) {
            fieldMap.put(field.name(), field);
        }
        return fieldMap;
    }

    public static Object getEnumValue(Schema schema, String symbol) {
        return Enum.valueOf(ReflectData.get().getClass(schema), symbol);
    }

    public static Object getEnumValue(Schema schema, int enumOrdinal) {
        String symbol = (String)schema.getEnumSymbols().get(enumOrdinal);
        return AvroUtils.getEnumValue(schema, symbol);
    }

    public static Schema getSchema(Class<? extends PersistentBase> clazz) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = clazz.getDeclaredField("SCHEMA$");
        return (Schema)field.get(null);
    }

    public static String[] getPersistentFieldNames(PersistentBase persistent) {
        return AvroUtils.getSchemaFieldNames(persistent.getSchema());
    }

    public static String[] getSchemaFieldNames(Schema schema) {
        List fields = schema.getFields();
        String[] fieldNames = new String[fields.size()];
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldNames[i] = ((Schema.Field)fields.get(i)).name();
        }
        return fieldNames;
    }

    public static <T extends PersistentBase> T deepClonePersistent(T persistent) {
        byte[] byteData;
        SpecificDatumWriter writer = new SpecificDatumWriter(persistent.getSchema());
        try {
            byteData = IOUtils.serialize(writer, persistent);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize avro object to byte buffer - please report this issue to the Gora bugtracker or your administrator.");
        }
        SpecificDatumReader reader = new SpecificDatumReader(persistent.getClass());
        try {
            return (T)((PersistentBase)IOUtils.deserialize(byteData, reader, null));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to deserialize avro object from byte buffer - please report this issue to the Gora bugtracker or your administrator.");
        }
    }
}

