/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.util;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.util.ByteBufferInputStream;
import org.apache.avro.util.ByteBufferOutputStream;
import org.apache.gora.util.ClassLoadingUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;

public class IOUtils {
    public static final int BUFFER_SIZE = 8192;
    private static BinaryDecoder decoder;

    private static Configuration getOrCreateConf(Configuration conf) {
        return conf != null ? conf : new Configuration();
    }

    public static Object readObject(DataInput in) throws ClassNotFoundException, IOException {
        if (in instanceof ObjectInput) {
            return ((ObjectInput)in).readObject();
        }
        if (in instanceof InputStream) {
            ObjectInputStream objIn = new ObjectInputStream((InputStream)((Object)in));
            Object obj = objIn.readObject();
            return obj;
        }
        throw new IOException("cannot read from DataInput of instance:" + in.getClass());
    }

    public static void writeObject(DataOutput out, Object obj) throws IOException {
        if (out instanceof ObjectOutput) {
            ((ObjectOutput)out).writeObject(obj);
        } else if (out instanceof OutputStream) {
            ObjectOutputStream objOut = new ObjectOutputStream((OutputStream)((Object)out));
            objOut.writeObject(obj);
        }
        throw new IOException("cannot write to DataOutput of instance:" + out.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void serialize(Configuration conf, DataOutput out, T obj, Class<T> objClass) throws IOException {
        SerializationFactory serializationFactory = new SerializationFactory(IOUtils.getOrCreateConf(conf));
        try (Serializer serializer = serializationFactory.getSerializer(objClass);
             ByteBufferOutputStream os = new ByteBufferOutputStream();){
            serializer.open((OutputStream)os);
            serializer.serialize(obj);
            int length = 0;
            List buffers = os.getBufferList();
            for (ByteBuffer buffer : buffers) {
                length += buffer.limit() - buffer.arrayOffset();
            }
            WritableUtils.writeVInt((DataOutput)out, (int)length);
            for (ByteBuffer buffer : buffers) {
                byte[] arr = buffer.array();
                out.write(arr, buffer.arrayOffset(), buffer.limit());
            }
        }
    }

    public static <T> void serialize(Configuration conf, DataOutput out, T obj) throws IOException {
        Text.writeString((DataOutput)out, (String)obj.getClass().getName());
        IOUtils.serialize(conf, out, obj, obj.getClass());
    }

    public static <T> byte[] serialize(Configuration conf, T obj) throws IOException {
        DataOutputBuffer buffer = new DataOutputBuffer();
        IOUtils.serialize(conf, (DataOutput)buffer, obj);
        return buffer.getData();
    }

    public static <T extends SpecificRecord> void serialize(OutputStream os, SpecificDatumWriter<T> datumWriter, T object) throws IOException {
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder(os, null);
        datumWriter.write(object, (Encoder)encoder);
        encoder.flush();
    }

    public static <T> void serialize(OutputStream os, SpecificDatumWriter<T> datumWriter, T object) throws IOException {
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder(os, null);
        datumWriter.write(object, (Encoder)encoder);
        encoder.flush();
    }

    public static <T extends SpecificRecord> byte[] serialize(SpecificDatumWriter<T> datumWriter, T object) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.serialize(os, datumWriter, object);
        return os.toByteArray();
    }

    public static <T> byte[] serialize(SpecificDatumWriter<T> datumWriter, T object) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.serialize(os, datumWriter, object);
        return os.toByteArray();
    }

    public static <T> T deserialize(Configuration conf, DataInput in, T obj, String objClass) throws IOException, ClassNotFoundException {
        Class<?> c = ClassLoadingUtils.loadClass(objClass);
        return IOUtils.deserialize(conf, in, obj, c);
    }

    /*
     * Loose catch block
     */
    public static <T> T deserialize(Configuration conf, DataInput in, T obj, Class<T> objClass) throws IOException {
        SerializationFactory serializationFactory = new SerializationFactory(IOUtils.getOrCreateConf(conf));
        Deserializer deserializer = serializationFactory.getDeserializer(objClass);
        int length = WritableUtils.readVInt((DataInput)in);
        byte[] arr = new byte[length];
        in.readFully(arr);
        ArrayList<ByteBuffer> list = new ArrayList<ByteBuffer>();
        list.add(ByteBuffer.wrap(arr));
        try {
            Object object;
            try (ByteBufferInputStream is = new ByteBufferInputStream(list);){
                deserializer.open((InputStream)is);
                object = deserializer.deserialize(obj);
            }
            return (T)object;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (deserializer != null) {
                deserializer.close();
            }
        }
    }

    public static <T> T deserialize(Configuration conf, DataInput in, T obj) throws IOException, ClassNotFoundException {
        String clazz = Text.readString((DataInput)in);
        Class<?> c = ClassLoadingUtils.loadClass(clazz);
        return IOUtils.deserialize(conf, in, obj, c);
    }

    public static <T> T deserialize(Configuration conf, byte[] in, T obj) throws IOException, ClassNotFoundException {
        try (DataInputBuffer buffer = new DataInputBuffer();){
            buffer.reset(in, in.length);
            T t = IOUtils.deserialize(conf, (DataInput)buffer, obj);
            return t;
        }
    }

    public static <K, T extends SpecificRecord> T deserialize(InputStream is, SpecificDatumReader<T> datumReader, T object) throws IOException {
        decoder = DecoderFactory.get().binaryDecoder(is, decoder);
        return (T)((SpecificRecord)datumReader.read(object, (Decoder)decoder));
    }

    public static <K, T extends SpecificRecord> T deserialize(byte[] bytes, SpecificDatumReader<T> datumReader, T object) throws IOException {
        decoder = DecoderFactory.get().binaryDecoder(bytes, decoder);
        return (T)((SpecificRecord)datumReader.read(object, (Decoder)decoder));
    }

    public static <K, T> T deserialize(byte[] bytes, SpecificDatumReader<T> datumReader, T object) throws IOException {
        decoder = DecoderFactory.get().binaryDecoder(bytes, decoder);
        return (T)datumReader.read(object, (Decoder)decoder);
    }

    public static void writeNullFieldsInfo(DataOutput out, Object ... fields) throws IOException {
        boolean[] isNull = new boolean[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            isNull[i] = fields[i] == null;
        }
        IOUtils.writeBoolArray(out, isNull);
    }

    public static boolean[] readNullFieldsInfo(DataInput in) throws IOException {
        return IOUtils.readBoolArray(in);
    }

    public static void writeBoolArray(DataOutput out, boolean[] boolArray) throws IOException {
        int i;
        WritableUtils.writeVInt((DataOutput)out, (int)boolArray.length);
        int b = 0;
        for (i = 0; i < boolArray.length; ++i) {
            if (i % 8 == 0 && i != 0) {
                out.writeByte(b);
                b = 0;
            }
            b = (byte)(b >> 1);
            b = boolArray[i] ? (int)((byte)(b | 0x80)) : (int)((byte)(b & 0x7F));
        }
        if (i % 8 != 0) {
            for (int j = 0; j < 8 - i % 8; ++j) {
                b = (byte)(b >> 1);
                b = (byte)(b & 0x7F);
            }
        }
        out.writeByte(b);
    }

    public static boolean[] readBoolArray(DataInput in) throws IOException {
        int length = WritableUtils.readVInt((DataInput)in);
        boolean[] arr = new boolean[length];
        byte b = 0;
        for (int i = 0; i < length; ++i) {
            if (i % 8 == 0) {
                b = in.readByte();
            }
            arr[i] = (b & 1) > 0;
            b = (byte)(b >> 1);
        }
        return arr;
    }

    public static void writeBoolArray(Encoder out, boolean[] boolArray) throws IOException {
        int i;
        out.writeInt(boolArray.length);
        int byteArrLength = (int)Math.ceil((double)boolArray.length / 8.0);
        int b = 0;
        byte[] arr = new byte[byteArrLength];
        int arrIndex = 0;
        for (i = 0; i < boolArray.length; ++i) {
            if (i % 8 == 0 && i != 0) {
                arr[arrIndex++] = b;
                b = 0;
            }
            b = (byte)(b >> 1);
            b = boolArray[i] ? (int)((byte)(b | 0x80)) : (int)((byte)(b & 0x7F));
        }
        if (i % 8 != 0) {
            for (int j = 0; j < 8 - i % 8; ++j) {
                b = (byte)(b >> 1);
                b = (byte)(b & 0x7F);
            }
        }
        arr[arrIndex++] = b;
        out.writeFixed(arr);
    }

    public static boolean[] readBoolArray(Decoder in) throws IOException {
        int length = in.readInt();
        boolean[] boolArr = new boolean[length];
        int byteArrLength = (int)Math.ceil((double)length / 8.0);
        byte[] byteArr = new byte[byteArrLength];
        in.readFixed(byteArr);
        int arrIndex = 0;
        byte b = 0;
        for (int i = 0; i < length; ++i) {
            if (i % 8 == 0) {
                b = byteArr[arrIndex++];
            }
            boolArr[i] = (b & 1) > 0;
            b = (byte)(b >> 1);
        }
        return boolArr;
    }

    public static void writeStringArray(DataOutput out, String[] arr) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)arr.length);
        for (String str : arr) {
            Text.writeString((DataOutput)out, (String)str);
        }
    }

    public static String[] readStringArray(DataInput in) throws IOException {
        int len = WritableUtils.readVInt((DataInput)in);
        String[] arr = new String[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = Text.readString((DataInput)in);
        }
        return arr;
    }

    public static <T> void storeToConf(T obj, Configuration conf, String dataKey) throws IOException {
        String classKey = dataKey + "._class";
        conf.set(classKey, obj.getClass().getName());
        DefaultStringifier.store((Configuration)conf, obj, (String)dataKey);
    }

    public static <T> T loadFromConf(Configuration conf, String dataKey) throws IOException {
        String classKey = dataKey + "._class";
        String className = conf.get(classKey);
        try {
            return (T)DefaultStringifier.load((Configuration)conf, (String)dataKey, ClassLoadingUtils.loadClass(className));
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new IOException(ex);
        }
    }

    public static byte[] getAsBytes(List<ByteBuffer> buffers) {
        int size = 0;
        for (ByteBuffer buffer : buffers) {
            size += buffer.remaining();
        }
        byte[] arr = new byte[size];
        int offset = 0;
        for (ByteBuffer buffer : buffers) {
            int len = buffer.remaining();
            buffer.get(arr, offset, len);
            offset += len;
        }
        return arr;
    }

    public static byte[] readFully(InputStream in) throws IOException {
        int count;
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(4);
        do {
            ByteBuffer buffer;
            if ((count = in.read((buffer = ByteBuffer.allocate(8192)).array(), 0, 8192)) <= 0) continue;
            buffer.limit(count);
            buffers.add(buffer);
        } while (count >= 8192);
        return IOUtils.getAsBytes(buffers);
    }
}

