/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.util;

import java.util.Stack;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeWalker {
    private Node currentNode;
    private NodeList currentChildren;
    private Stack<Node> nodes = new Stack();

    public NodeWalker(Node rootNode) {
        this.nodes.add(rootNode);
    }

    public Node nextNode() {
        if (!this.hasNext()) {
            return null;
        }
        this.currentNode = this.nodes.pop();
        this.currentChildren = this.currentNode.getChildNodes();
        int childLen = this.currentChildren != null ? this.currentChildren.getLength() : 0;
        for (int i = childLen - 1; i >= 0; --i) {
            this.nodes.add(this.currentChildren.item(i));
        }
        return this.currentNode;
    }

    public void skipChildren() {
        int childLen = this.currentChildren != null ? this.currentChildren.getLength() : 0;
        for (int i = 0; i < childLen; ++i) {
            Node child = this.nodes.peek();
            if (!child.equals(this.currentChildren.item(i))) continue;
            this.nodes.pop();
        }
    }

    public boolean hasNext() {
        return this.nodes.size() > 0;
    }
}

