/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.util;

import org.apache.gora.GoraVersionAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionInfo {
    private static final Logger LOG = LoggerFactory.getLogger(VersionInfo.class);
    private static Package myPackage = GoraVersionAnnotation.class.getPackage();
    private static GoraVersionAnnotation version = myPackage.getAnnotation(GoraVersionAnnotation.class);

    static Package getPackage() {
        return myPackage;
    }

    public static String getVersion() {
        return version != null ? version.version() : "Unknown";
    }

    public static String getRevision() {
        return version != null ? version.revision() : "Unknown";
    }

    public static String getDate() {
        return version != null ? version.date() : "Unknown";
    }

    public static String getUser() {
        return version != null ? version.user() : "Unknown";
    }

    public static String getUrl() {
        return version != null ? version.url() : "Unknown";
    }

    public static String getSrcChecksum() {
        return version != null ? version.srcChecksum() : "Unknown";
    }

    public static String getBuildVersion() {
        return VersionInfo.getVersion() + " from " + VersionInfo.getRevision() + " by " + VersionInfo.getUser() + " source checksum " + VersionInfo.getSrcChecksum();
    }

    public static void main(String[] args) {
        LOG.info("Gora " + VersionInfo.getVersion());
        LOG.info("Subversion " + VersionInfo.getUrl() + " -r " + VersionInfo.getRevision());
        LOG.info("Compiled by " + VersionInfo.getUser() + " on " + VersionInfo.getDate());
        LOG.info("From source with checksum " + VersionInfo.getSrcChecksum());
    }
}

