/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb;

import java.util.ArrayList;
import java.util.List;
import shaded.com.mongodb.AcknowledgedBulkWriteResult;
import shaded.com.mongodb.BulkWriteException;
import shaded.com.mongodb.BulkWriteResult;
import shaded.com.mongodb.BulkWriteUpsert;
import shaded.com.mongodb.DBObject;
import shaded.com.mongodb.DBObjects;
import shaded.com.mongodb.MongoBulkWriteException;
import shaded.com.mongodb.UnacknowledgedBulkWriteResult;
import shaded.com.mongodb.bulk.BulkWriteError;
import shaded.com.mongodb.bulk.WriteConcernError;
import shaded.org.bson.BsonDocument;
import shaded.org.bson.BsonDocumentReader;
import shaded.org.bson.codecs.Decoder;
import shaded.org.bson.codecs.DecoderContext;

final class BulkWriteHelper {
    static BulkWriteResult translateBulkWriteResult(shaded.com.mongodb.bulk.BulkWriteResult bulkWriteResult, Decoder<DBObject> decoder) {
        if (bulkWriteResult.wasAcknowledged()) {
            return new AcknowledgedBulkWriteResult(bulkWriteResult.getInsertedCount(), bulkWriteResult.getMatchedCount(), bulkWriteResult.getDeletedCount(), bulkWriteResult.getModifiedCount(), BulkWriteHelper.translateBulkWriteUpserts(bulkWriteResult.getUpserts(), decoder));
        }
        return new UnacknowledgedBulkWriteResult();
    }

    static List<BulkWriteUpsert> translateBulkWriteUpserts(List<shaded.com.mongodb.bulk.BulkWriteUpsert> upserts, Decoder<DBObject> decoder) {
        ArrayList<BulkWriteUpsert> retVal = new ArrayList<BulkWriteUpsert>(upserts.size());
        for (shaded.com.mongodb.bulk.BulkWriteUpsert cur : upserts) {
            retVal.add(new BulkWriteUpsert(cur.getIndex(), BulkWriteHelper.getUpsertedId(cur, decoder)));
        }
        return retVal;
    }

    private static Object getUpsertedId(shaded.com.mongodb.bulk.BulkWriteUpsert cur, Decoder<DBObject> decoder) {
        return decoder.decode(new BsonDocumentReader(new BsonDocument("_id", cur.getId())), DecoderContext.builder().build()).get("_id");
    }

    static BulkWriteException translateBulkWriteException(MongoBulkWriteException e, Decoder<DBObject> decoder) {
        return new BulkWriteException(BulkWriteHelper.translateBulkWriteResult(e.getWriteResult(), decoder), BulkWriteHelper.translateWriteErrors(e.getWriteErrors()), BulkWriteHelper.translateWriteConcernError(e.getWriteConcernError()), e.getServerAddress());
    }

    static shaded.com.mongodb.WriteConcernError translateWriteConcernError(WriteConcernError writeConcernError) {
        return writeConcernError == null ? null : new shaded.com.mongodb.WriteConcernError(writeConcernError.getCode(), writeConcernError.getMessage(), DBObjects.toDBObject(writeConcernError.getDetails()));
    }

    static List<shaded.com.mongodb.BulkWriteError> translateWriteErrors(List<BulkWriteError> errors) {
        ArrayList<shaded.com.mongodb.BulkWriteError> retVal = new ArrayList<shaded.com.mongodb.BulkWriteError>(errors.size());
        for (BulkWriteError cur : errors) {
            retVal.add(new shaded.com.mongodb.BulkWriteError(cur.getCode(), cur.getMessage(), DBObjects.toDBObject(cur.getDetails()), cur.getIndex()));
        }
        return retVal;
    }

    private BulkWriteHelper() {
    }
}

