/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb;

import java.nio.ByteBuffer;
import shaded.com.mongodb.DBEncoder;
import shaded.com.mongodb.DBObject;
import shaded.com.mongodb.assertions.Assertions;
import shaded.org.bson.BsonBinaryReader;
import shaded.org.bson.BsonWriter;
import shaded.org.bson.ByteBufNIO;
import shaded.org.bson.codecs.Encoder;
import shaded.org.bson.codecs.EncoderContext;
import shaded.org.bson.io.BasicOutputBuffer;
import shaded.org.bson.io.ByteBufferBsonInput;

class DBEncoderAdapter
implements Encoder<DBObject> {
    private final DBEncoder encoder;

    DBEncoderAdapter(DBEncoder encoder) {
        this.encoder = Assertions.notNull("encoder", encoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(BsonWriter writer, DBObject document, EncoderContext encoderContext) {
        BasicOutputBuffer buffer = new BasicOutputBuffer();
        try {
            this.encoder.writeObject(buffer, document);
            BsonBinaryReader reader = new BsonBinaryReader(new ByteBufferBsonInput(new ByteBufNIO(ByteBuffer.wrap(buffer.toByteArray()))));
            try {
                writer.pipe(reader);
            }
            finally {
                reader.close();
            }
        }
        finally {
            buffer.close();
        }
    }

    @Override
    public Class<DBObject> getEncoderClass() {
        return DBObject.class;
    }
}

