/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb;

import java.util.Date;
import java.util.List;
import shaded.com.mongodb.BSONTimestampCodec;
import shaded.com.mongodb.DBObject;
import shaded.com.mongodb.DBObjectCodec;
import shaded.com.mongodb.assertions.Assertions;
import shaded.org.bson.codecs.BsonTypeClassMap;
import shaded.org.bson.codecs.Codec;
import shaded.org.bson.codecs.DateCodec;
import shaded.org.bson.codecs.configuration.CodecProvider;
import shaded.org.bson.codecs.configuration.CodecRegistry;
import shaded.org.bson.types.BSONTimestamp;

public class DBObjectCodecProvider
implements CodecProvider {
    private final BsonTypeClassMap bsonTypeClassMap;

    public DBObjectCodecProvider() {
        this(DBObjectCodec.getDefaultBsonTypeClassMap());
    }

    public DBObjectCodecProvider(BsonTypeClassMap bsonTypeClassMap) {
        this.bsonTypeClassMap = Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (clazz == BSONTimestamp.class) {
            return new BSONTimestampCodec();
        }
        if (DBObject.class.isAssignableFrom(clazz) && !List.class.isAssignableFrom(clazz)) {
            return new DBObjectCodec(registry, this.bsonTypeClassMap);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new DateCodec();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

