/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb;

import java.io.Serializable;
import shaded.com.mongodb.assertions.Assertions;
import shaded.com.mongodb.lang.Nullable;

public class DBRef
implements Serializable {
    private static final long serialVersionUID = -849581217713362618L;
    private final Object id;
    private final String collectionName;
    private final String databaseName;

    public DBRef(String collectionName, Object id) {
        this(null, collectionName, id);
    }

    public DBRef(@Nullable String databaseName, String collectionName, Object id) {
        this.id = Assertions.notNull("id", id);
        this.collectionName = Assertions.notNull("collectionName", collectionName);
        this.databaseName = databaseName;
    }

    public Object getId() {
        return this.id;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    @Nullable
    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBRef dbRef = (DBRef)o;
        if (!this.id.equals(dbRef.id)) {
            return false;
        }
        if (!this.collectionName.equals(dbRef.collectionName)) {
            return false;
        }
        return !(this.databaseName != null ? !this.databaseName.equals(dbRef.databaseName) : dbRef.databaseName != null);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.collectionName.hashCode();
        result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "{ \"$ref\" : \"" + this.collectionName + "\", \"$id\" : \"" + this.id + "\"" + (this.databaseName == null ? "" : ", \"$db\" : \"" + this.databaseName + "\"") + " }";
    }
}

