/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb;

import java.io.IOException;
import java.io.InputStream;
import shaded.com.mongodb.DBCallback;
import shaded.com.mongodb.DBCollection;
import shaded.com.mongodb.DBDecoder;
import shaded.com.mongodb.DBDecoderFactory;
import shaded.com.mongodb.DBObject;
import shaded.com.mongodb.DefaultDBCallback;
import shaded.org.bson.BSONCallback;
import shaded.org.bson.BasicBSONDecoder;

public class DefaultDBDecoder
extends BasicBSONDecoder
implements DBDecoder {
    public static final DBDecoderFactory FACTORY = new DBDecoderFactory(){

        @Override
        public DBDecoder create() {
            return new DefaultDBDecoder();
        }
    };

    @Override
    public DBCallback getDBCallback(DBCollection collection) {
        return new DefaultDBCallback(collection);
    }

    @Override
    public DBObject decode(InputStream input, DBCollection collection) throws IOException {
        DBCallback callback = this.getDBCallback(collection);
        this.decode(input, (BSONCallback)callback);
        return (DBObject)callback.get();
    }

    @Override
    public DBObject decode(byte[] bytes, DBCollection collection) {
        DBCallback callback = this.getDBCallback(collection);
        this.decode(bytes, (BSONCallback)callback);
        return (DBObject)callback.get();
    }

    public String toString() {
        return String.format("DBDecoder{class=%s}", this.getClass().getName());
    }
}

