/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb;

import shaded.com.mongodb.MongoCommandException;
import shaded.com.mongodb.MongoServerException;
import shaded.com.mongodb.ServerAddress;

public class MongoQueryException
extends MongoServerException {
    private static final long serialVersionUID = -5113350133297015801L;
    private final String errorMessage;

    public MongoQueryException(ServerAddress address, int errorCode, String errorMessage) {
        super(errorCode, String.format("Query failed with error code %d and error message '%s' on server %s", errorCode, errorMessage, address), address);
        this.errorMessage = errorMessage;
    }

    public MongoQueryException(MongoCommandException commandException) {
        this(commandException.getServerAddress(), commandException.getErrorCode(), commandException.getErrorMessage());
        for (String label : commandException.getErrorLabels()) {
            this.addLabel(label);
        }
    }

    public int getErrorCode() {
        return this.getCode();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

