/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb;

import shaded.com.mongodb.DBCollection;
import shaded.com.mongodb.DBObject;
import shaded.com.mongodb.WriteRequest;
import shaded.com.mongodb.bulk.UpdateRequest;
import shaded.com.mongodb.bulk.WriteRequest;
import shaded.com.mongodb.client.model.Collation;
import shaded.org.bson.BsonDocumentWrapper;
import shaded.org.bson.codecs.Encoder;

class ReplaceRequest
extends WriteRequest {
    private final DBObject query;
    private final DBObject document;
    private final boolean upsert;
    private final Encoder<DBObject> codec;
    private final Encoder<DBObject> replacementCodec;
    private final Collation collation;

    ReplaceRequest(DBObject query, DBObject document, boolean upsert, Encoder<DBObject> codec, Encoder<DBObject> replacementCodec, Collation collation) {
        this.query = query;
        this.document = document;
        this.upsert = upsert;
        this.codec = codec;
        this.replacementCodec = replacementCodec;
        this.collation = collation;
    }

    public DBObject getQuery() {
        return this.query;
    }

    public DBObject getDocument() {
        return this.document;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public Collation getCollation() {
        return this.collation;
    }

    @Override
    shaded.com.mongodb.bulk.WriteRequest toNew(DBCollection dbCollection) {
        return new UpdateRequest(new BsonDocumentWrapper<DBObject>(this.query, this.codec), new BsonDocumentWrapper<DBObject>(this.document, this.replacementCodec), WriteRequest.Type.REPLACE).upsert(this.isUpsert()).collation(this.getCollation());
    }
}

