/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb.client.internal;

import java.io.Closeable;
import shaded.com.mongodb.ClientEncryptionSettings;
import shaded.com.mongodb.MongoNamespace;
import shaded.com.mongodb.WriteConcern;
import shaded.com.mongodb.client.MongoClient;
import shaded.com.mongodb.client.MongoClients;
import shaded.com.mongodb.client.internal.Crypt;
import shaded.com.mongodb.client.internal.Crypts;
import shaded.com.mongodb.client.internal.SimpleMongoClients;
import shaded.com.mongodb.client.model.vault.DataKeyOptions;
import shaded.com.mongodb.client.model.vault.EncryptOptions;
import shaded.com.mongodb.client.vault.ClientEncryption;
import shaded.org.bson.BsonBinary;
import shaded.org.bson.BsonDocument;
import shaded.org.bson.BsonValue;

public class ClientEncryptionImpl
implements ClientEncryption,
Closeable {
    private final Crypt crypt;
    private final ClientEncryptionSettings options;
    private final MongoClient keyVaultClient;

    public ClientEncryptionImpl(ClientEncryptionSettings options) {
        this.keyVaultClient = MongoClients.create(options.getKeyVaultMongoClientSettings());
        this.crypt = Crypts.create(SimpleMongoClients.create(this.keyVaultClient), options);
        this.options = options;
    }

    @Override
    public BsonBinary createDataKey(String kmsProvider) {
        return this.createDataKey(kmsProvider, new DataKeyOptions());
    }

    @Override
    public BsonBinary createDataKey(String kmsProvider, DataKeyOptions dataKeyOptions) {
        BsonDocument dataKeyDocument = this.crypt.createDataKey(kmsProvider, dataKeyOptions);
        MongoNamespace namespace = new MongoNamespace(this.options.getKeyVaultNamespace());
        this.keyVaultClient.getDatabase(namespace.getDatabaseName()).getCollection(namespace.getCollectionName(), BsonDocument.class).withWriteConcern(WriteConcern.MAJORITY).insertOne(dataKeyDocument);
        return dataKeyDocument.getBinary("_id");
    }

    @Override
    public BsonBinary encrypt(BsonValue value, EncryptOptions options) {
        return this.crypt.encryptExplicitly(value, options);
    }

    @Override
    public BsonValue decrypt(BsonBinary value) {
        return this.crypt.decryptExplicitly(value);
    }

    @Override
    public void close() {
        this.crypt.close();
        this.keyVaultClient.close();
    }
}

