/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb.client.internal;

import java.io.Closeable;
import java.util.Map;
import shaded.com.mongodb.MongoClientException;
import shaded.com.mongodb.MongoException;
import shaded.com.mongodb.MongoTimeoutException;
import shaded.com.mongodb.ReadConcern;
import shaded.com.mongodb.ReadPreference;
import shaded.com.mongodb.assertions.Assertions;
import shaded.com.mongodb.client.MongoClient;
import shaded.com.mongodb.client.MongoClients;
import shaded.com.mongodb.internal.capi.MongoCryptHelper;
import shaded.org.bson.RawBsonDocument;
import shaded.org.bson.conversions.Bson;

class CommandMarker
implements Closeable {
    private final MongoClient client;
    private final ProcessBuilder processBuilder;

    CommandMarker(boolean isBypassAutoEncryption, Map<String, Object> options) {
        if (isBypassAutoEncryption) {
            this.processBuilder = null;
            this.client = null;
            return;
        }
        if (!options.containsKey("mongocryptdBypassSpawn") || !((Boolean)options.get("mongocryptdBypassSpawn")).booleanValue()) {
            this.processBuilder = MongoCryptHelper.createProcessBuilder(options);
            MongoCryptHelper.startProcess(this.processBuilder);
        } else {
            this.processBuilder = null;
        }
        this.client = MongoClients.create(MongoCryptHelper.createMongocryptdClientSettings((String)options.get("mongocryptdURI")));
    }

    RawBsonDocument mark(String databaseName, RawBsonDocument command) {
        Assertions.notNull("client", this.client);
        try {
            try {
                return this.executeCommand(databaseName, command);
            }
            catch (MongoTimeoutException e) {
                if (this.processBuilder == null) {
                    throw e;
                }
                MongoCryptHelper.startProcess(this.processBuilder);
                return this.executeCommand(databaseName, command);
            }
        }
        catch (MongoException e) {
            throw this.wrapInClientException(e);
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private RawBsonDocument executeCommand(String databaseName, RawBsonDocument markableCommand) {
        return this.client.getDatabase(databaseName).withReadConcern(ReadConcern.DEFAULT).withReadPreference(ReadPreference.primary()).runCommand((Bson)markableCommand, RawBsonDocument.class);
    }

    private MongoClientException wrapInClientException(MongoException e) {
        return new MongoClientException("Exception in encryption library: " + e.getMessage(), e);
    }
}

