/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb.client.internal;

import java.util.concurrent.TimeUnit;
import shaded.com.mongodb.ReadConcern;
import shaded.com.mongodb.ReadPreference;
import shaded.com.mongodb.assertions.Assertions;
import shaded.com.mongodb.client.ClientSession;
import shaded.com.mongodb.client.ListDatabasesIterable;
import shaded.com.mongodb.client.internal.MongoIterableImpl;
import shaded.com.mongodb.client.internal.OperationExecutor;
import shaded.com.mongodb.internal.operation.SyncOperations;
import shaded.com.mongodb.lang.Nullable;
import shaded.com.mongodb.operation.BatchCursor;
import shaded.com.mongodb.operation.ReadOperation;
import shaded.org.bson.BsonDocument;
import shaded.org.bson.codecs.configuration.CodecRegistry;
import shaded.org.bson.conversions.Bson;

class ListDatabasesIterableImpl<TResult>
extends MongoIterableImpl<TResult>
implements ListDatabasesIterable<TResult> {
    private final SyncOperations<BsonDocument> operations;
    private final Class<TResult> resultClass;
    private long maxTimeMS;
    private Bson filter;
    private Boolean nameOnly;

    ListDatabasesIterableImpl(@Nullable ClientSession clientSession, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, OperationExecutor executor) {
        this(clientSession, resultClass, codecRegistry, readPreference, executor, true);
    }

    ListDatabasesIterableImpl(@Nullable ClientSession clientSession, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, OperationExecutor executor, boolean retryReads) {
        super(clientSession, executor, ReadConcern.DEFAULT, readPreference, retryReads);
        this.operations = new SyncOperations<BsonDocument>(BsonDocument.class, readPreference, codecRegistry, retryReads);
        this.resultClass = Assertions.notNull("clazz", resultClass);
    }

    @Override
    public ListDatabasesIterableImpl<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListDatabasesIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public ListDatabasesIterable<TResult> filter(@Nullable Bson filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public ListDatabasesIterable<TResult> nameOnly(@Nullable Boolean nameOnly) {
        this.nameOnly = nameOnly;
        return this;
    }

    @Override
    public ReadOperation<BatchCursor<TResult>> asReadOperation() {
        return this.operations.listDatabases(this.resultClass, this.filter, this.nameOnly, this.maxTimeMS);
    }
}

