/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb.client.internal;

import java.util.Collection;
import shaded.com.mongodb.Block;
import shaded.com.mongodb.Function;
import shaded.com.mongodb.client.MongoCursor;
import shaded.com.mongodb.client.MongoIterable;
import shaded.com.mongodb.client.internal.MongoMappingCursor;
import shaded.com.mongodb.lang.Nullable;

class MappingIterable<U, V>
implements MongoIterable<V> {
    private final MongoIterable<U> iterable;
    private final Function<U, V> mapper;

    MappingIterable(MongoIterable<U> iterable, Function<U, V> mapper) {
        this.iterable = iterable;
        this.mapper = mapper;
    }

    @Override
    public MongoCursor<V> iterator() {
        return new MongoMappingCursor<U, V>(this.iterable.iterator(), this.mapper);
    }

    @Override
    public MongoCursor<V> cursor() {
        return this.iterator();
    }

    @Override
    @Nullable
    public V first() {
        U first = this.iterable.first();
        if (first == null) {
            return null;
        }
        return this.mapper.apply(first);
    }

    @Override
    public void forEach(final Block<? super V> block) {
        this.iterable.forEach(new Block<U>(){

            @Override
            public void apply(U document) {
                block.apply(MappingIterable.this.mapper.apply(document));
            }
        });
    }

    @Override
    public <A extends Collection<? super V>> A into(final A target) {
        this.forEach(new Block<V>(){

            @Override
            public void apply(V v) {
                target.add(v);
            }
        });
        return target;
    }

    public MappingIterable<U, V> batchSize(int batchSize) {
        this.iterable.batchSize(batchSize);
        return this;
    }

    @Override
    public <W> MongoIterable<W> map(Function<V, W> newMap) {
        return new MappingIterable<V, W>(this, newMap);
    }

    MongoIterable<U> getMapped() {
        return this.iterable;
    }
}

