/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb.client.model.geojson;

import java.io.StringWriter;
import shaded.com.mongodb.client.model.geojson.CoordinateReferenceSystem;
import shaded.com.mongodb.client.model.geojson.GeoJsonObjectType;
import shaded.com.mongodb.client.model.geojson.codecs.GeoJsonCodecProvider;
import shaded.com.mongodb.lang.Nullable;
import shaded.org.bson.codecs.Codec;
import shaded.org.bson.codecs.EncoderContext;
import shaded.org.bson.codecs.configuration.CodecRegistries;
import shaded.org.bson.codecs.configuration.CodecRegistry;
import shaded.org.bson.json.JsonWriter;
import shaded.org.bson.json.JsonWriterSettings;

public abstract class Geometry {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new GeoJsonCodecProvider());
    private final CoordinateReferenceSystem coordinateReferenceSystem;

    protected Geometry() {
        this(null);
    }

    protected Geometry(@Nullable CoordinateReferenceSystem coordinateReferenceSystem) {
        this.coordinateReferenceSystem = coordinateReferenceSystem;
    }

    public abstract GeoJsonObjectType getType();

    public String toJson() {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter, new JsonWriterSettings());
        Codec<?> codec = Geometry.getRegistry().get(this.getClass());
        codec.encode(writer, this, EncoderContext.builder().build());
        return stringWriter.toString();
    }

    static CodecRegistry getRegistry() {
        return REGISTRY;
    }

    @Nullable
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Geometry geometry = (Geometry)o;
        return !(this.coordinateReferenceSystem != null ? !this.coordinateReferenceSystem.equals(geometry.coordinateReferenceSystem) : geometry.coordinateReferenceSystem != null);
    }

    public int hashCode() {
        return this.coordinateReferenceSystem != null ? this.coordinateReferenceSystem.hashCode() : 0;
    }
}

