/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb.client.model.geojson.codecs;

import shaded.com.mongodb.client.model.geojson.Geometry;
import shaded.com.mongodb.client.model.geojson.codecs.GeometryDecoderHelper;
import shaded.com.mongodb.client.model.geojson.codecs.GeometryEncoderHelper;
import shaded.org.bson.BsonReader;
import shaded.org.bson.BsonWriter;
import shaded.org.bson.codecs.Codec;
import shaded.org.bson.codecs.DecoderContext;
import shaded.org.bson.codecs.EncoderContext;
import shaded.org.bson.codecs.configuration.CodecRegistry;

abstract class AbstractGeometryCodec<T extends Geometry>
implements Codec<T> {
    private final CodecRegistry registry;
    private final Class<T> encoderClass;

    AbstractGeometryCodec(CodecRegistry registry, Class<T> encoderClass) {
        this.registry = registry;
        this.encoderClass = encoderClass;
    }

    @Override
    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        GeometryEncoderHelper.encodeGeometry(writer, value, encoderContext, this.registry);
    }

    @Override
    public T decode(BsonReader reader, DecoderContext decoderContext) {
        return GeometryDecoderHelper.decodeGeometry(reader, this.getEncoderClass());
    }

    @Override
    public Class<T> getEncoderClass() {
        return this.encoderClass;
    }
}

