/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import shaded.com.mongodb.assertions.Assertions;
import shaded.com.mongodb.diagnostics.logging.Logger;
import shaded.com.mongodb.diagnostics.logging.Loggers;
import shaded.com.mongodb.event.ServerHeartbeatFailedEvent;
import shaded.com.mongodb.event.ServerHeartbeatStartedEvent;
import shaded.com.mongodb.event.ServerHeartbeatSucceededEvent;
import shaded.com.mongodb.event.ServerMonitorListener;

@Deprecated
public final class ServerMonitorEventMulticaster
implements ServerMonitorListener {
    private static final Logger LOGGER = Loggers.getLogger("cluster.event");
    private final List<ServerMonitorListener> serverMonitorListeners;

    public ServerMonitorEventMulticaster(List<ServerMonitorListener> serverMonitorListeners) {
        Assertions.notNull("serverMonitorListeners", serverMonitorListeners);
        Assertions.isTrue("All ServerMonitorListener instances are non-null", !serverMonitorListeners.contains(null));
        this.serverMonitorListeners = new ArrayList<ServerMonitorListener>(serverMonitorListeners);
    }

    public List<ServerMonitorListener> getServerMonitorListeners() {
        return Collections.unmodifiableList(this.serverMonitorListeners);
    }

    @Override
    public void serverHearbeatStarted(ServerHeartbeatStartedEvent event) {
        for (ServerMonitorListener cur : this.serverMonitorListeners) {
            try {
                cur.serverHearbeatStarted(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising server heartbeat started event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void serverHeartbeatSucceeded(ServerHeartbeatSucceededEvent event) {
        for (ServerMonitorListener cur : this.serverMonitorListeners) {
            try {
                cur.serverHeartbeatSucceeded(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising server heartbeat succeeded event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void serverHeartbeatFailed(ServerHeartbeatFailedEvent event) {
        for (ServerMonitorListener cur : this.serverMonitorListeners) {
            try {
                cur.serverHeartbeatFailed(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising server heartbeat failed event to listener %s", cur), e);
            }
        }
    }
}

