/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb.internal.connection;

import shaded.com.mongodb.MongoNamespace;
import shaded.com.mongodb.MongoServerException;
import shaded.com.mongodb.ReadPreference;
import shaded.com.mongodb.async.SingleResultCallback;
import shaded.com.mongodb.internal.connection.ClusterClock;
import shaded.com.mongodb.internal.connection.ClusterClockAdvancingSessionContext;
import shaded.com.mongodb.internal.connection.CommandMessage;
import shaded.com.mongodb.internal.connection.InternalConnection;
import shaded.com.mongodb.internal.connection.MessageSettings;
import shaded.com.mongodb.internal.connection.NoOpSessionContext;
import shaded.com.mongodb.internal.validator.NoOpFieldNameValidator;
import shaded.com.mongodb.session.SessionContext;
import shaded.org.bson.BsonDocument;
import shaded.org.bson.BsonValue;
import shaded.org.bson.codecs.BsonDocumentCodec;

public final class CommandHelper {
    static BsonDocument executeCommand(String database, BsonDocument command, InternalConnection internalConnection) {
        return CommandHelper.sendAndReceive(database, command, null, internalConnection);
    }

    public static BsonDocument executeCommand(String database, BsonDocument command, ClusterClock clusterClock, InternalConnection internalConnection) {
        return CommandHelper.sendAndReceive(database, command, clusterClock, internalConnection);
    }

    static BsonDocument executeCommandWithoutCheckingForFailure(String database, BsonDocument command, InternalConnection internalConnection) {
        try {
            return CommandHelper.sendAndReceive(database, command, null, internalConnection);
        }
        catch (MongoServerException e) {
            return new BsonDocument();
        }
    }

    static void executeCommandAsync(String database, BsonDocument command, InternalConnection internalConnection, final SingleResultCallback<BsonDocument> callback) {
        internalConnection.sendAndReceiveAsync(CommandHelper.getCommandMessage(database, command, internalConnection), new BsonDocumentCodec(), NoOpSessionContext.INSTANCE, new SingleResultCallback<BsonDocument>(){

            @Override
            public void onResult(BsonDocument result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(result, null);
                }
            }
        });
    }

    static boolean isCommandOk(BsonDocument response) {
        if (!response.containsKey("ok")) {
            return false;
        }
        BsonValue okValue = response.get("ok");
        if (okValue.isBoolean()) {
            return okValue.asBoolean().getValue();
        }
        if (okValue.isNumber()) {
            return okValue.asNumber().intValue() == 1;
        }
        return false;
    }

    private static BsonDocument sendAndReceive(String database, BsonDocument command, ClusterClock clusterClock, InternalConnection internalConnection) {
        SessionContext sessionContext = clusterClock == null ? NoOpSessionContext.INSTANCE : new ClusterClockAdvancingSessionContext(NoOpSessionContext.INSTANCE, clusterClock);
        return internalConnection.sendAndReceive(CommandHelper.getCommandMessage(database, command, internalConnection), new BsonDocumentCodec(), sessionContext);
    }

    private static CommandMessage getCommandMessage(String database, BsonDocument command, InternalConnection internalConnection) {
        return new CommandMessage(new MongoNamespace(database, "$cmd"), command, new NoOpFieldNameValidator(), ReadPreference.primary(), MessageSettings.builder().maxWireVersion(internalConnection.getDescription().getMaxWireVersion()).build());
    }

    private CommandHelper() {
    }
}

