/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb.internal.connection;

import shaded.com.mongodb.ServerAddress;
import shaded.com.mongodb.async.SingleResultCallback;
import shaded.com.mongodb.diagnostics.logging.Logger;
import shaded.com.mongodb.diagnostics.logging.Loggers;
import shaded.com.mongodb.internal.connection.CommandResultBaseCallback;
import shaded.com.mongodb.internal.connection.ProtocolHelper;
import shaded.org.bson.BsonDocument;
import shaded.org.bson.BsonDocumentReader;
import shaded.org.bson.codecs.BsonDocumentCodec;
import shaded.org.bson.codecs.Decoder;
import shaded.org.bson.codecs.DecoderContext;

class CommandResultCallback<T>
extends CommandResultBaseCallback<BsonDocument> {
    public static final Logger LOGGER = Loggers.getLogger("protocol.command");
    private final SingleResultCallback<T> callback;
    private final Decoder<T> decoder;

    CommandResultCallback(SingleResultCallback<T> callback, Decoder<T> decoder, long requestId, ServerAddress serverAddress) {
        super(new BsonDocumentCodec(), requestId, serverAddress);
        this.callback = callback;
        this.decoder = decoder;
    }

    @Override
    protected void callCallback(BsonDocument response, Throwable t) {
        if (t != null) {
            this.callback.onResult(null, t);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Command execution completed with status " + ProtocolHelper.isCommandOk(response));
            }
            if (!ProtocolHelper.isCommandOk(response)) {
                this.callback.onResult(null, ProtocolHelper.getCommandFailureException(response, this.getServerAddress()));
            } else {
                try {
                    this.callback.onResult(this.decoder.decode(new BsonDocumentReader(response), DecoderContext.builder().build()), null);
                }
                catch (Throwable t1) {
                    this.callback.onResult(null, t1);
                }
            }
        }
    }
}

