/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb.internal.connection;

import java.util.concurrent.TimeUnit;
import shaded.com.mongodb.connection.ClusterId;
import shaded.com.mongodb.connection.ServerSettings;
import shaded.com.mongodb.internal.connection.DefaultDnsSrvRecordMonitor;
import shaded.com.mongodb.internal.connection.DnsSrvRecordInitializer;
import shaded.com.mongodb.internal.connection.DnsSrvRecordMonitor;
import shaded.com.mongodb.internal.connection.DnsSrvRecordMonitorFactory;
import shaded.com.mongodb.internal.dns.DefaultDnsResolver;

public class DefaultDnsSrvRecordMonitorFactory
implements DnsSrvRecordMonitorFactory {
    private static final long DEFAULT_RESCAN_FREQUENCY_MILLIS = 60000L;
    private final ClusterId clusterId;
    private final long noRecordsRescanFrequency;

    public DefaultDnsSrvRecordMonitorFactory(ClusterId clusterId, ServerSettings serverSettings) {
        this.clusterId = clusterId;
        this.noRecordsRescanFrequency = serverSettings.getHeartbeatFrequency(TimeUnit.MILLISECONDS);
    }

    @Override
    public DnsSrvRecordMonitor create(String hostName, DnsSrvRecordInitializer dnsSrvRecordInitializer) {
        return new DefaultDnsSrvRecordMonitor(hostName, 60000L, this.noRecordsRescanFrequency, dnsSrvRecordInitializer, this.clusterId, new DefaultDnsResolver());
    }
}

