/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb.internal.connection;

import shaded.com.mongodb.assertions.Assertions;
import shaded.com.mongodb.connection.ServerDescription;
import shaded.com.mongodb.connection.ServerId;
import shaded.com.mongodb.connection.ServerSettings;
import shaded.com.mongodb.internal.connection.ChangeListener;
import shaded.com.mongodb.internal.connection.ClusterClock;
import shaded.com.mongodb.internal.connection.ConnectionPool;
import shaded.com.mongodb.internal.connection.DefaultServerMonitor;
import shaded.com.mongodb.internal.connection.InternalConnectionFactory;
import shaded.com.mongodb.internal.connection.ServerMonitor;
import shaded.com.mongodb.internal.connection.ServerMonitorFactory;

class DefaultServerMonitorFactory
implements ServerMonitorFactory {
    private final ServerId serverId;
    private final ServerSettings settings;
    private final ClusterClock clusterClock;
    private final InternalConnectionFactory internalConnectionFactory;
    private final ConnectionPool connectionPool;

    DefaultServerMonitorFactory(ServerId serverId, ServerSettings settings, ClusterClock clusterClock, InternalConnectionFactory internalConnectionFactory, ConnectionPool connectionPool) {
        this.serverId = Assertions.notNull("serverId", serverId);
        this.settings = Assertions.notNull("settings", settings);
        this.clusterClock = Assertions.notNull("clusterClock", clusterClock);
        this.internalConnectionFactory = Assertions.notNull("internalConnectionFactory", internalConnectionFactory);
        this.connectionPool = Assertions.notNull("connectionPool", connectionPool);
    }

    @Override
    public ServerMonitor create(ChangeListener<ServerDescription> serverStateListener) {
        return new DefaultServerMonitor(this.serverId, this.settings, this.clusterClock, serverStateListener, this.internalConnectionFactory, this.connectionPool);
    }
}

