/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb.internal.connection;

import java.util.List;
import shaded.com.mongodb.internal.connection.BsonWriterHelper;
import shaded.com.mongodb.internal.connection.LevelCountingBsonWriter;
import shaded.org.bson.BsonBinaryWriter;
import shaded.org.bson.BsonElement;
import shaded.org.bson.BsonReader;

public class ElementExtendingBsonWriter
extends LevelCountingBsonWriter {
    private final List<BsonElement> extraElements;

    public ElementExtendingBsonWriter(BsonBinaryWriter writer, List<BsonElement> extraElements) {
        super(writer);
        this.extraElements = extraElements;
    }

    @Override
    public void writeEndDocument() {
        if (this.getCurrentLevel() == 0) {
            BsonWriterHelper.writeElements(this.getBsonBinaryWriter(), this.extraElements);
        }
        super.writeEndDocument();
    }

    @Override
    public void pipe(BsonReader reader) {
        if (this.getCurrentLevel() == -1) {
            this.getBsonBinaryWriter().pipe(reader, this.extraElements);
        } else {
            this.getBsonBinaryWriter().pipe(reader);
        }
    }
}

