/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb.operation;

import shaded.com.mongodb.MongoNamespace;
import shaded.com.mongodb.WriteConcern;
import shaded.com.mongodb.assertions.Assertions;
import shaded.com.mongodb.async.SingleResultCallback;
import shaded.com.mongodb.binding.AsyncWriteBinding;
import shaded.com.mongodb.binding.WriteBinding;
import shaded.com.mongodb.connection.ConnectionDescription;
import shaded.com.mongodb.connection.ServerDescription;
import shaded.com.mongodb.internal.operation.ServerVersionHelper;
import shaded.com.mongodb.operation.AsyncWriteOperation;
import shaded.com.mongodb.operation.CommandOperationHelper;
import shaded.com.mongodb.operation.CommandResultDocumentCodec;
import shaded.com.mongodb.operation.FindAndModifyHelper;
import shaded.com.mongodb.operation.OperationHelper;
import shaded.com.mongodb.operation.WriteOperation;
import shaded.com.mongodb.session.SessionContext;
import shaded.org.bson.BsonDocument;
import shaded.org.bson.BsonInt64;
import shaded.org.bson.FieldNameValidator;
import shaded.org.bson.codecs.Decoder;

@Deprecated
public abstract class BaseFindAndModifyOperation<T>
implements AsyncWriteOperation<T>,
WriteOperation<T> {
    private final MongoNamespace namespace;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final Decoder<T> decoder;

    protected BaseFindAndModifyOperation(MongoNamespace namespace, WriteConcern writeConcern, boolean retryWrites, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.retryWrites = retryWrites;
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    @Override
    public T execute(WriteBinding binding) {
        return CommandOperationHelper.executeRetryableCommand(binding, this.getDatabaseName(), null, this.getFieldNameValidator(), CommandResultDocumentCodec.create(this.getDecoder(), "value"), this.getCommandCreator(binding.getSessionContext()), FindAndModifyHelper.<BsonDocument>transformer());
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeRetryableCommand(binding, this.getDatabaseName(), null, this.getFieldNameValidator(), CommandResultDocumentCodec.create(this.getDecoder(), "value"), this.getCommandCreator(binding.getSessionContext()), FindAndModifyHelper.<BsonDocument>asyncTransformer(), callback);
    }

    protected abstract String getDatabaseName();

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public boolean isRetryWrites() {
        return this.retryWrites;
    }

    protected abstract CommandOperationHelper.CommandCreator getCommandCreator(SessionContext var1);

    protected void addTxnNumberToCommand(ServerDescription serverDescription, ConnectionDescription connectionDescription, BsonDocument commandDocument, SessionContext sessionContext) {
        if (OperationHelper.isRetryableWrite(this.isRetryWrites(), this.getWriteConcern(), serverDescription, connectionDescription, sessionContext)) {
            commandDocument.put("txnNumber", new BsonInt64(sessionContext.advanceTransactionNumber()));
        }
    }

    protected void addWriteConcernToCommand(ConnectionDescription connectionDescription, BsonDocument commandDocument, SessionContext sessionContext) {
        if (this.getWriteConcern().isAcknowledged() && !this.getWriteConcern().isServerDefault() && ServerVersionHelper.serverIsAtLeastVersionThreeDotTwo(connectionDescription) && !sessionContext.hasActiveTransaction()) {
            commandDocument.put("writeConcern", this.getWriteConcern().asDocument());
        }
    }

    protected abstract FieldNameValidator getFieldNameValidator();
}

