/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb.operation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import shaded.com.mongodb.MongoChangeStreamException;
import shaded.com.mongodb.MongoCursorNotFoundException;
import shaded.com.mongodb.MongoException;
import shaded.com.mongodb.MongoInterruptedException;
import shaded.com.mongodb.MongoNotPrimaryException;
import shaded.com.mongodb.MongoSocketException;

final class ChangeStreamBatchCursorHelper {
    private static final List<Integer> UNRETRYABLE_SERVER_ERROR_CODES = Arrays.asList(136, 237, 280, 11601);
    private static final List<String> NONRESUMABLE_CHANGE_STREAM_ERROR_LABELS = Arrays.asList("NonResumableChangeStreamError");

    static boolean isRetryableError(Throwable t) {
        if (!(t instanceof MongoException) || t instanceof MongoChangeStreamException || t instanceof MongoInterruptedException) {
            return false;
        }
        if (t instanceof MongoNotPrimaryException || t instanceof MongoCursorNotFoundException || t instanceof MongoSocketException) {
            return true;
        }
        return !UNRETRYABLE_SERVER_ERROR_CODES.contains(((MongoException)t).getCode()) && Collections.disjoint(NONRESUMABLE_CHANGE_STREAM_ERROR_LABELS, ((MongoException)t).getErrorLabels());
    }

    private ChangeStreamBatchCursorHelper() {
    }
}

