/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb.operation;

import java.util.ArrayList;
import shaded.com.mongodb.operation.BsonArrayWrapper;
import shaded.org.bson.BsonArray;
import shaded.org.bson.BsonDocumentWrapper;
import shaded.org.bson.BsonReader;
import shaded.org.bson.BsonType;
import shaded.org.bson.BsonValue;
import shaded.org.bson.codecs.BsonArrayCodec;
import shaded.org.bson.codecs.Decoder;
import shaded.org.bson.codecs.DecoderContext;
import shaded.org.bson.codecs.configuration.CodecRegistry;

class CommandResultArrayCodec<T>
extends BsonArrayCodec {
    private final Decoder<T> decoder;

    CommandResultArrayCodec(CodecRegistry registry, Decoder<T> decoder) {
        super(registry);
        this.decoder = decoder;
    }

    @Override
    public BsonArray decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartArray();
        ArrayList<T> list = new ArrayList<T>();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            if (reader.getCurrentBsonType() == BsonType.NULL) {
                reader.readNull();
                list.add(null);
                continue;
            }
            list.add(this.decoder.decode(reader, decoderContext));
        }
        reader.readEndArray();
        return new BsonArrayWrapper(list);
    }

    @Override
    protected BsonValue readValue(BsonReader reader, DecoderContext decoderContext) {
        if (reader.getCurrentBsonType() == BsonType.DOCUMENT) {
            return new BsonDocumentWrapper<T>(this.decoder.decode(reader, decoderContext), null);
        }
        return super.readValue(reader, decoderContext);
    }
}

