/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb.operation;

import java.util.Collections;
import java.util.List;
import shaded.com.mongodb.operation.CommandResultArrayCodec;
import shaded.com.mongodb.operation.CommandResultCodecProvider;
import shaded.org.bson.BsonDocument;
import shaded.org.bson.BsonDocumentWrapper;
import shaded.org.bson.BsonReader;
import shaded.org.bson.BsonType;
import shaded.org.bson.BsonValue;
import shaded.org.bson.codecs.BsonDocumentCodec;
import shaded.org.bson.codecs.Codec;
import shaded.org.bson.codecs.Decoder;
import shaded.org.bson.codecs.DecoderContext;
import shaded.org.bson.codecs.configuration.CodecRegistries;
import shaded.org.bson.codecs.configuration.CodecRegistry;

class CommandResultDocumentCodec<T>
extends BsonDocumentCodec {
    private final Decoder<T> payloadDecoder;
    private final List<String> fieldsContainingPayload;

    CommandResultDocumentCodec(CodecRegistry registry, Decoder<T> payloadDecoder, List<String> fieldsContainingPayload) {
        super(registry);
        this.payloadDecoder = payloadDecoder;
        this.fieldsContainingPayload = fieldsContainingPayload;
    }

    static <P> Codec<BsonDocument> create(Decoder<P> decoder, String fieldContainingPayload) {
        return CommandResultDocumentCodec.create(decoder, Collections.singletonList(fieldContainingPayload));
    }

    static <P> Codec<BsonDocument> create(Decoder<P> decoder, List<String> fieldsContainingPayload) {
        CodecRegistry registry = CodecRegistries.fromProviders(new CommandResultCodecProvider<P>(decoder, fieldsContainingPayload));
        return registry.get(BsonDocument.class);
    }

    @Override
    protected BsonValue readValue(BsonReader reader, DecoderContext decoderContext) {
        if (this.fieldsContainingPayload.contains(reader.getCurrentName())) {
            if (reader.getCurrentBsonType() == BsonType.DOCUMENT) {
                return new BsonDocumentWrapper<T>(this.payloadDecoder.decode(reader, decoderContext), null);
            }
            if (reader.getCurrentBsonType() == BsonType.ARRAY) {
                return new CommandResultArrayCodec<T>(this.getCodecRegistry(), this.payloadDecoder).decode(reader, decoderContext);
            }
        }
        return super.readValue(reader, decoderContext);
    }
}

