/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb.operation;

import shaded.com.mongodb.assertions.Assertions;
import shaded.com.mongodb.async.SingleResultCallback;
import shaded.com.mongodb.binding.AsyncConnectionSource;
import shaded.com.mongodb.binding.AsyncReadBinding;
import shaded.com.mongodb.binding.ConnectionSource;
import shaded.com.mongodb.binding.ReadBinding;
import shaded.com.mongodb.connection.AsyncConnection;
import shaded.com.mongodb.connection.Connection;
import shaded.com.mongodb.connection.ConnectionDescription;
import shaded.com.mongodb.connection.ServerDescription;
import shaded.com.mongodb.internal.async.ErrorHandlingResultCallback;
import shaded.com.mongodb.operation.AsyncReadOperation;
import shaded.com.mongodb.operation.CommandOperationHelper;
import shaded.com.mongodb.operation.OperationHelper;
import shaded.com.mongodb.operation.ReadOperation;
import shaded.org.bson.BsonDocument;
import shaded.org.bson.BsonString;
import shaded.org.bson.codecs.BsonDocumentCodec;

@Deprecated
public class UserExistsOperation
implements AsyncReadOperation<Boolean>,
ReadOperation<Boolean> {
    private final String databaseName;
    private final String userName;
    private boolean retryReads;

    public UserExistsOperation(String databaseName, String userName) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.userName = Assertions.notNull("userName", userName);
    }

    public UserExistsOperation retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    @Override
    public Boolean execute(final ReadBinding binding) {
        return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<Boolean>(){

            @Override
            public Boolean call(Connection connection) {
                return (Boolean)CommandOperationHelper.executeCommand(binding, UserExistsOperation.this.databaseName, UserExistsOperation.this.getCommandCreator(), UserExistsOperation.this.transformer(), UserExistsOperation.this.retryReads);
            }
        });
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<Boolean> callback) {
        CommandOperationHelper.executeCommandAsync(binding, this.databaseName, this.getCommandCreator(), new BsonDocumentCodec(), this.asyncTransformer(), this.retryReads, ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    private CommandOperationHelper.CommandReadTransformer<BsonDocument, Boolean> transformer() {
        return new CommandOperationHelper.CommandReadTransformer<BsonDocument, Boolean>(){

            @Override
            public Boolean apply(BsonDocument result, ConnectionSource source, Connection connection) {
                return result.get("users").isArray() && !result.getArray("users").isEmpty();
            }
        };
    }

    private CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, Boolean> asyncTransformer() {
        return new CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, Boolean>(){

            @Override
            public Boolean apply(BsonDocument result, AsyncConnectionSource source, AsyncConnection connection) {
                return result.get("users").isArray() && !result.getArray("users").isEmpty();
            }
        };
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return new CommandOperationHelper.CommandCreator(){

            @Override
            public BsonDocument create(ServerDescription serverDescription, ConnectionDescription connectionDescription) {
                return UserExistsOperation.this.getCommand();
            }
        };
    }

    private BsonDocument getCommand() {
        return new BsonDocument("usersInfo", new BsonString(this.userName));
    }
}

