/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bson.codecs;

import java.util.ArrayList;
import shaded.org.bson.BsonArray;
import shaded.org.bson.BsonReader;
import shaded.org.bson.BsonType;
import shaded.org.bson.BsonValue;
import shaded.org.bson.BsonWriter;
import shaded.org.bson.assertions.Assertions;
import shaded.org.bson.codecs.BsonValueCodecProvider;
import shaded.org.bson.codecs.Codec;
import shaded.org.bson.codecs.DecoderContext;
import shaded.org.bson.codecs.EncoderContext;
import shaded.org.bson.codecs.configuration.CodecRegistries;
import shaded.org.bson.codecs.configuration.CodecRegistry;

public class BsonArrayCodec
implements Codec<BsonArray> {
    private static final CodecRegistry DEFAULT_REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private final CodecRegistry codecRegistry;

    public BsonArrayCodec() {
        this(DEFAULT_REGISTRY);
    }

    public BsonArrayCodec(CodecRegistry codecRegistry) {
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
    }

    @Override
    public BsonArray decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartArray();
        ArrayList<BsonValue> list = new ArrayList<BsonValue>();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            list.add(this.readValue(reader, decoderContext));
        }
        reader.readEndArray();
        return new BsonArray(list);
    }

    @Override
    public void encode(BsonWriter writer, BsonArray array, EncoderContext encoderContext) {
        writer.writeStartArray();
        for (BsonValue value : array) {
            Codec<?> codec = this.codecRegistry.get(value.getClass());
            encoderContext.encodeWithChildContext(codec, writer, value);
        }
        writer.writeEndArray();
    }

    @Override
    public Class<BsonArray> getEncoderClass() {
        return BsonArray.class;
    }

    protected BsonValue readValue(BsonReader reader, DecoderContext decoderContext) {
        return (BsonValue)this.codecRegistry.get(BsonValueCodecProvider.getClassForBsonType(reader.getCurrentBsonType())).decode(reader, decoderContext);
    }
}

