/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bson.codecs;

import java.util.HashMap;
import java.util.Map;
import shaded.org.bson.BsonArray;
import shaded.org.bson.BsonBinary;
import shaded.org.bson.BsonBoolean;
import shaded.org.bson.BsonDateTime;
import shaded.org.bson.BsonDbPointer;
import shaded.org.bson.BsonDecimal128;
import shaded.org.bson.BsonDocument;
import shaded.org.bson.BsonDocumentWrapper;
import shaded.org.bson.BsonDouble;
import shaded.org.bson.BsonInt32;
import shaded.org.bson.BsonInt64;
import shaded.org.bson.BsonJavaScript;
import shaded.org.bson.BsonJavaScriptWithScope;
import shaded.org.bson.BsonMaxKey;
import shaded.org.bson.BsonMinKey;
import shaded.org.bson.BsonNull;
import shaded.org.bson.BsonObjectId;
import shaded.org.bson.BsonRegularExpression;
import shaded.org.bson.BsonString;
import shaded.org.bson.BsonSymbol;
import shaded.org.bson.BsonTimestamp;
import shaded.org.bson.BsonType;
import shaded.org.bson.BsonUndefined;
import shaded.org.bson.BsonValue;
import shaded.org.bson.RawBsonDocument;
import shaded.org.bson.codecs.BsonArrayCodec;
import shaded.org.bson.codecs.BsonBinaryCodec;
import shaded.org.bson.codecs.BsonBooleanCodec;
import shaded.org.bson.codecs.BsonDBPointerCodec;
import shaded.org.bson.codecs.BsonDateTimeCodec;
import shaded.org.bson.codecs.BsonDecimal128Codec;
import shaded.org.bson.codecs.BsonDocumentCodec;
import shaded.org.bson.codecs.BsonDocumentWrapperCodec;
import shaded.org.bson.codecs.BsonDoubleCodec;
import shaded.org.bson.codecs.BsonInt32Codec;
import shaded.org.bson.codecs.BsonInt64Codec;
import shaded.org.bson.codecs.BsonJavaScriptCodec;
import shaded.org.bson.codecs.BsonJavaScriptWithScopeCodec;
import shaded.org.bson.codecs.BsonMaxKeyCodec;
import shaded.org.bson.codecs.BsonMinKeyCodec;
import shaded.org.bson.codecs.BsonNullCodec;
import shaded.org.bson.codecs.BsonObjectIdCodec;
import shaded.org.bson.codecs.BsonRegularExpressionCodec;
import shaded.org.bson.codecs.BsonStringCodec;
import shaded.org.bson.codecs.BsonSymbolCodec;
import shaded.org.bson.codecs.BsonTimestampCodec;
import shaded.org.bson.codecs.BsonTypeClassMap;
import shaded.org.bson.codecs.BsonUndefinedCodec;
import shaded.org.bson.codecs.BsonValueCodec;
import shaded.org.bson.codecs.Codec;
import shaded.org.bson.codecs.RawBsonDocumentCodec;
import shaded.org.bson.codecs.configuration.CodecProvider;
import shaded.org.bson.codecs.configuration.CodecRegistry;

public class BsonValueCodecProvider
implements CodecProvider {
    private static final BsonTypeClassMap DEFAULT_BSON_TYPE_CLASS_MAP;
    private final Map<Class<?>, Codec<?>> codecs = new HashMap();

    public BsonValueCodecProvider() {
        this.addCodecs();
    }

    public static Class<? extends BsonValue> getClassForBsonType(BsonType bsonType) {
        return DEFAULT_BSON_TYPE_CLASS_MAP.get(bsonType);
    }

    public static BsonTypeClassMap getBsonTypeClassMap() {
        return DEFAULT_BSON_TYPE_CLASS_MAP;
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (this.codecs.containsKey(clazz)) {
            return this.codecs.get(clazz);
        }
        if (clazz == BsonJavaScriptWithScope.class) {
            return new BsonJavaScriptWithScopeCodec(registry.get(BsonDocument.class));
        }
        if (clazz == BsonValue.class) {
            return new BsonValueCodec(registry);
        }
        if (clazz == BsonDocumentWrapper.class) {
            return new BsonDocumentWrapperCodec(registry.get(BsonDocument.class));
        }
        if (clazz == RawBsonDocument.class) {
            return new RawBsonDocumentCodec();
        }
        if (BsonDocument.class.isAssignableFrom(clazz)) {
            return new BsonDocumentCodec(registry);
        }
        if (BsonArray.class.isAssignableFrom(clazz)) {
            return new BsonArrayCodec(registry);
        }
        return null;
    }

    private void addCodecs() {
        this.addCodec(new BsonNullCodec());
        this.addCodec(new BsonBinaryCodec());
        this.addCodec(new BsonBooleanCodec());
        this.addCodec(new BsonDateTimeCodec());
        this.addCodec(new BsonDBPointerCodec());
        this.addCodec(new BsonDoubleCodec());
        this.addCodec(new BsonInt32Codec());
        this.addCodec(new BsonInt64Codec());
        this.addCodec(new BsonDecimal128Codec());
        this.addCodec(new BsonMinKeyCodec());
        this.addCodec(new BsonMaxKeyCodec());
        this.addCodec(new BsonJavaScriptCodec());
        this.addCodec(new BsonObjectIdCodec());
        this.addCodec(new BsonRegularExpressionCodec());
        this.addCodec(new BsonStringCodec());
        this.addCodec(new BsonSymbolCodec());
        this.addCodec(new BsonTimestampCodec());
        this.addCodec(new BsonUndefinedCodec());
    }

    private <T extends BsonValue> void addCodec(Codec<T> codec) {
        this.codecs.put(codec.getEncoderClass(), codec);
    }

    static {
        HashMap map = new HashMap();
        map.put(BsonType.NULL, BsonNull.class);
        map.put(BsonType.ARRAY, BsonArray.class);
        map.put(BsonType.BINARY, BsonBinary.class);
        map.put(BsonType.BOOLEAN, BsonBoolean.class);
        map.put(BsonType.DATE_TIME, BsonDateTime.class);
        map.put(BsonType.DB_POINTER, BsonDbPointer.class);
        map.put(BsonType.DOCUMENT, BsonDocument.class);
        map.put(BsonType.DOUBLE, BsonDouble.class);
        map.put(BsonType.INT32, BsonInt32.class);
        map.put(BsonType.INT64, BsonInt64.class);
        map.put(BsonType.DECIMAL128, BsonDecimal128.class);
        map.put(BsonType.MAX_KEY, BsonMaxKey.class);
        map.put(BsonType.MIN_KEY, BsonMinKey.class);
        map.put(BsonType.JAVASCRIPT, BsonJavaScript.class);
        map.put(BsonType.JAVASCRIPT_WITH_SCOPE, BsonJavaScriptWithScope.class);
        map.put(BsonType.OBJECT_ID, BsonObjectId.class);
        map.put(BsonType.REGULAR_EXPRESSION, BsonRegularExpression.class);
        map.put(BsonType.STRING, BsonString.class);
        map.put(BsonType.SYMBOL, BsonSymbol.class);
        map.put(BsonType.TIMESTAMP, BsonTimestamp.class);
        map.put(BsonType.UNDEFINED, BsonUndefined.class);
        DEFAULT_BSON_TYPE_CLASS_MAP = new BsonTypeClassMap(map);
    }
}

