/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bson.codecs;

import shaded.org.bson.BsonInvalidOperationException;
import shaded.org.bson.BsonReader;
import shaded.org.bson.BsonWriter;
import shaded.org.bson.codecs.Codec;
import shaded.org.bson.codecs.DecoderContext;
import shaded.org.bson.codecs.EncoderContext;
import shaded.org.bson.codecs.NumberCodecHelper;

public class ByteCodec
implements Codec<Byte> {
    @Override
    public void encode(BsonWriter writer, Byte value, EncoderContext encoderContext) {
        writer.writeInt32(value.byteValue());
    }

    @Override
    public Byte decode(BsonReader reader, DecoderContext decoderContext) {
        int value = NumberCodecHelper.decodeInt(reader);
        if (value < -128 || value > 127) {
            throw new BsonInvalidOperationException(String.format("%s can not be converted into a Byte.", value));
        }
        return (byte)value;
    }

    @Override
    public Class<Byte> getEncoderClass() {
        return Byte.class;
    }
}

