/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bson.codecs.jsr310;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import shaded.org.bson.BsonReader;
import shaded.org.bson.BsonWriter;
import shaded.org.bson.codecs.DecoderContext;
import shaded.org.bson.codecs.EncoderContext;
import shaded.org.bson.codecs.configuration.CodecConfigurationException;
import shaded.org.bson.codecs.jsr310.DateTimeBasedCodec;

public class LocalDateCodec
extends DateTimeBasedCodec<LocalDate> {
    @Override
    public LocalDate decode(BsonReader reader, DecoderContext decoderContext) {
        return Instant.ofEpochMilli(this.validateAndReadDateTime(reader)).atZone(ZoneOffset.UTC).toLocalDate();
    }

    @Override
    public void encode(BsonWriter writer, LocalDate value, EncoderContext encoderContext) {
        try {
            writer.writeDateTime(value.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli());
        }
        catch (ArithmeticException e) {
            throw new CodecConfigurationException(String.format("Unsupported LocalDate '%s' could not be converted to milliseconds: %s", value, e.getMessage()), e);
        }
    }

    @Override
    public Class<LocalDate> getEncoderClass() {
        return LocalDate.class;
    }
}

