/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bson.diagnostics;

import shaded.org.bson.assertions.Assertions;
import shaded.org.bson.diagnostics.JULLogger;
import shaded.org.bson.diagnostics.Logger;
import shaded.org.bson.diagnostics.SLF4JLogger;

public final class Loggers {
    public static final String PREFIX = "shaded.org.bson";
    private static final boolean USE_SLF4J = Loggers.shouldUseSLF4J();

    public static Logger getLogger(String suffix) {
        Assertions.notNull("suffix", suffix);
        if (suffix.startsWith(".") || suffix.endsWith(".")) {
            throw new IllegalArgumentException("The suffix can not start or end with a '.'");
        }
        String name = "shaded.org.bson." + suffix;
        if (USE_SLF4J) {
            return new SLF4JLogger(name);
        }
        return new JULLogger(name);
    }

    private static boolean shouldUseSLF4J() {
        try {
            Class.forName("org.slf4j.Logger");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private Loggers() {
    }
}

