/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boot.common;

import ai.platon.pulsar.common.LogsKt;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.ClassUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J%\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lai/platon/pulsar/boot/common/SpringPackageScanClassResolver;", "", "()V", "logger", "Lorg/slf4j/Logger;", "findAllClasses", "", "Ljava/lang/Class;", "packageName", "", "loader", "Ljava/lang/ClassLoader;", "handleFailure", "", "resource", "Lorg/springframework/core/io/Resource;", "ex", "", "loadClass", "readerFactory", "Lorg/springframework/core/type/classreading/MetadataReaderFactory;", "scan", "", "(Ljava/lang/ClassLoader;Ljava/lang/String;)[Lorg/springframework/core/io/Resource;", "pulsar-boot"})
public final class SpringPackageScanClassResolver {
    @NotNull
    private final Logger logger = LogsKt.getLogger((Object)this);

    @NotNull
    public final Set<Class<?>> findAllClasses(@NotNull String packageName, @NotNull ClassLoader loader) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory(loader);
        boolean bl = false;
        Set foundClasses = new LinkedHashSet();
        try {
            Resource[] resources;
            for (Resource resource : resources = this.scan(loader, packageName)) {
                Class<?> clazz = this.loadClass(loader, (MetadataReaderFactory)metadataReaderFactory, resource);
                Class<?> clazz2 = clazz;
                if (clazz2 == null) continue;
                Class<?> clazz3 = clazz2;
                boolean bl2 = false;
                boolean bl3 = false;
                Class<?> it = clazz3;
                boolean bl4 = false;
                foundClasses.add(it);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return foundClasses;
    }

    private final Resource[] scan(ClassLoader loader, String packageName) throws IOException {
        ResourcePatternResolver resolver = (ResourcePatternResolver)new PathMatchingResourcePatternResolver(loader);
        String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)packageName) + "/**/*.class";
        Resource[] resourceArray = resolver.getResources(pattern);
        Intrinsics.checkNotNullExpressionValue((Object)resourceArray, (String)"resolver.getResources(pattern)");
        return resourceArray;
    }

    private final Class<?> loadClass(ClassLoader loader, MetadataReaderFactory readerFactory, Resource resource) {
        Class clazz;
        try {
            MetadataReader metadataReader = readerFactory.getMetadataReader(resource);
            Intrinsics.checkNotNullExpressionValue((Object)metadataReader, (String)"readerFactory.getMetadataReader(resource)");
            MetadataReader reader = metadataReader;
            clazz = ClassUtils.forName((String)reader.getClassMetadata().getClassName(), (ClassLoader)loader);
        }
        catch (ClassNotFoundException ex) {
            this.handleFailure(resource, ex);
            clazz = null;
        }
        catch (LinkageError ex) {
            this.handleFailure(resource, ex);
            clazz = null;
        }
        catch (Throwable ex) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Unexpected failure when loading class resource " + resource, ex);
            }
            clazz = null;
        }
        return clazz;
    }

    private final void handleFailure(Resource resource, Throwable ex) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignoring candidate class resource " + resource + " due to " + ex);
        }
    }
}

