/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boot.autoconfigure;

import ai.platon.pulsar.ql.context.H2SQLContext;
import ai.platon.pulsar.ql.context.SQLContext;
import ai.platon.pulsar.ql.context.SQLContexts;
import ai.platon.pulsar.skeleton.crawl.CrawlLoops;
import ai.platon.pulsar.skeleton.crawl.common.GlobalCache;
import ai.platon.pulsar.skeleton.crawl.common.GlobalCacheFactory;
import ai.platon.pulsar.skeleton.session.PulsarSession;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.Scope;

@Configuration
@ImportResource(value={"classpath:pulsar-beans/app-context.xml"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lai/platon/pulsar/boot/autoconfigure/PulsarContextConfiguration;", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "globalCache", "Lai/platon/pulsar/skeleton/crawl/common/GlobalCache;", "globalCacheFactory", "Lai/platon/pulsar/skeleton/crawl/common/GlobalCacheFactory;", "crawlLoops", "Lai/platon/pulsar/skeleton/crawl/CrawlLoops;", "(Lorg/springframework/context/ApplicationContext;Lai/platon/pulsar/skeleton/crawl/common/GlobalCache;Lai/platon/pulsar/skeleton/crawl/common/GlobalCacheFactory;Lai/platon/pulsar/skeleton/crawl/CrawlLoops;)V", "getApplicationContext", "()Lorg/springframework/context/ApplicationContext;", "getCrawlLoops", "()Lai/platon/pulsar/skeleton/crawl/CrawlLoops;", "getGlobalCache", "()Lai/platon/pulsar/skeleton/crawl/common/GlobalCache;", "getGlobalCacheFactory", "()Lai/platon/pulsar/skeleton/crawl/common/GlobalCacheFactory;", "getPulsarSession", "Lai/platon/pulsar/skeleton/session/PulsarSession;", "pulsar-boot"})
public class PulsarContextConfiguration {
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final GlobalCache globalCache;
    @NotNull
    private final GlobalCacheFactory globalCacheFactory;
    @NotNull
    private final CrawlLoops crawlLoops;

    public PulsarContextConfiguration(@NotNull ApplicationContext applicationContext, @NotNull GlobalCache globalCache, @NotNull GlobalCacheFactory globalCacheFactory, @NotNull CrawlLoops crawlLoops) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)globalCache, (String)"globalCache");
        Intrinsics.checkNotNullParameter((Object)globalCacheFactory, (String)"globalCacheFactory");
        Intrinsics.checkNotNullParameter((Object)crawlLoops, (String)"crawlLoops");
        this.applicationContext = applicationContext;
        this.globalCache = globalCache;
        this.globalCacheFactory = globalCacheFactory;
        this.crawlLoops = crawlLoops;
    }

    @NotNull
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @NotNull
    public GlobalCache getGlobalCache() {
        return this.globalCache;
    }

    @NotNull
    public GlobalCacheFactory getGlobalCacheFactory() {
        return this.globalCacheFactory;
    }

    @NotNull
    public CrawlLoops getCrawlLoops() {
        return this.crawlLoops;
    }

    @Bean
    @Scope(value="prototype")
    @NotNull
    public PulsarSession getPulsarSession() {
        SQLContext context = SQLContexts.INSTANCE.create(this.getApplicationContext());
        if (!(context instanceof H2SQLContext)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!Intrinsics.areEqual((Object)((H2SQLContext)context).getApplicationContext(), (Object)this.getApplicationContext())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return (PulsarSession)((H2SQLContext)context).createSession();
    }
}

