/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.concurrent;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0015\u001a\u00020\u0016J'\u0010\u0017\u001a\u00028\u00012\u0006\u0010\u0018\u001a\u00028\u00002\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001c\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001d\u0010 \u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010!\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0007\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Lai/platon/pulsar/common/concurrent/ConcurrentLRUCache;", "K", "V", "", "capacity", "", "(I)V", "ttl", "Ljava/time/Duration;", "(Ljava/time/Duration;I)V", "", "(JI)V", "cache", "Ljava/util/LinkedHashMap;", "", "size", "getSize", "()I", "<set-?>", "getTtl", "()J", "clear", "", "computeIfAbsent", "key", "mappingFunction", "Lkotlin/Function1;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "getTTLKey", "(Ljava/lang/Object;)Ljava/lang/String;", "put", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "remove", "pulsar-common"})
public final class ConcurrentLRUCache<K, V> {
    @NotNull
    private final LinkedHashMap<String, V> cache;
    private long ttl;

    public final long getTtl() {
        return this.ttl;
    }

    public final int getSize() {
        return this.cache.size();
    }

    public ConcurrentLRUCache(int capacity) {
        this(0L, capacity);
    }

    public ConcurrentLRUCache(@NotNull Duration ttl, final int capacity) {
        Intrinsics.checkNotNullParameter((Object)ttl, (String)"ttl");
        this.ttl = ttl.getSeconds();
        this.cache = new LinkedHashMap<String, V>(){

            @Override
            protected boolean removeEldestEntry(@NotNull Map.Entry<String, ? extends V> eldest) {
                Intrinsics.checkNotNullParameter(eldest, (String)"eldest");
                return this.size() > capacity;
            }
        };
    }

    public ConcurrentLRUCache(long ttl, final int capacity) {
        this.ttl = ttl;
        this.cache = new LinkedHashMap<String, V>(){

            @Override
            protected boolean removeEldestEntry(@NotNull Map.Entry<String, ? extends V> eldest) {
                Intrinsics.checkNotNullParameter(eldest, (String)"eldest");
                return this.size() > capacity;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final V get(K key) {
        String ttlKey = this.getTTLKey(key);
        LinkedHashMap<String, V> linkedHashMap = this.cache;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (linkedHashMap) {
            boolean bl3 = false;
            V v = this.cache.get(ttlKey);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final V put(K key, V value) {
        V v;
        String ttlKey = this.getTTLKey(key);
        LinkedHashMap<String, V> linkedHashMap = this.cache;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (linkedHashMap) {
            boolean bl3 = false;
            v = this.cache.put(ttlKey, value);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final V remove(K key) {
        String ttlKey = this.getTTLKey(key);
        LinkedHashMap<String, V> linkedHashMap = this.cache;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (linkedHashMap) {
            boolean bl3 = false;
            Object v = this.cache.remove(ttlKey);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V computeIfAbsent(K key, @NotNull Function1<? super K, ? extends V> mappingFunction) {
        Intrinsics.checkNotNullParameter(mappingFunction, (String)"mappingFunction");
        String ttlKey = this.getTTLKey(key);
        LinkedHashMap<String, V> linkedHashMap = this.cache;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (linkedHashMap) {
            Object object;
            boolean bl3 = false;
            V v = this.cache.get(ttlKey);
            if (v == null) {
                Object object2 = mappingFunction.invoke(key);
                boolean bl4 = false;
                boolean bl5 = false;
                Object it = object2;
                boolean bl6 = false;
                Map map = this.cache;
                boolean bl7 = false;
                map.put(ttlKey, it);
                object = object2;
            } else {
                object = v;
            }
            V v2 = object;
            return v2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        LinkedHashMap<String, V> linkedHashMap = this.cache;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (linkedHashMap) {
            boolean bl3 = false;
            this.cache.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final String getTTLKey(K key) {
        if (this.ttl <= 0L) {
            return String.valueOf(key);
        }
        long secondsDivTTL = System.currentTimeMillis() / (long)1000 / this.ttl;
        return secondsDivTTL + "\t" + key;
    }
}

