/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020)H\u0002J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,H\u0002J\u0014\u0010/\u001a\u00020)2\n\u00100\u001a\u000601j\u0002`2H\u0002J\n\u00103\u001a\u0004\u0018\u00010!H\u0002J*\u00104\u001a\u00020)2\u0006\u00105\u001a\u00020\u00052\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,2\n\b\u0002\u00106\u001a\u0004\u0018\u000107J.\u00104\u001a\u00020)2\u0006\u00105\u001a\u00020\u00052\n\u00108\u001a\u0006\u0012\u0002\b\u0003092\u0006\u0010.\u001a\u00020,2\n\b\u0002\u00106\u001a\u0004\u0018\u000107J\u000e\u00104\u001a\u00020)2\u0006\u0010.\u001a\u00020,J\u001c\u0010:\u001a\u00020)2\u0006\u0010.\u001a\u00020,2\n\b\u0002\u00106\u001a\u0004\u0018\u000107H\u0002R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\t\"\u0004\b\u0017\u0010\u000bR\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\t\"\u0004\b\u001d\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006<"}, d2={"Lai/platon/pulsar/common/MessageWriter;", "Ljava/lang/AutoCloseable;", "path", "Ljava/nio/file/Path;", "levelFile", "", "(Ljava/nio/file/Path;I)V", "checkSize", "getCheckSize", "()I", "setCheckSize", "(I)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "dateFormat", "Ljava/text/SimpleDateFormat;", "getDateFormat", "()Ljava/text/SimpleDateFormat;", "setDateFormat", "(Ljava/text/SimpleDateFormat;)V", "fileWriter", "Ljava/io/Writer;", "getLevelFile", "setLevelFile", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "maxFileSize", "getMaxFileSize", "setMaxFileSize", "getPath", "()Ljava/nio/file/Path;", "printWriter", "Ljava/io/PrintWriter;", "writingError", "", "getWritingError", "()Z", "setWritingError", "(Z)V", "close", "", "closeWriter", "format", "", "module", "s", "logWritingError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "openWriter", "write", "level", "t", "", "clazz", "Lkotlin/reflect/KClass;", "writeFile", "Companion", "pulsar-common"})
public final class MessageWriter
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;
    private int levelFile;
    private final Logger log;
    @Nullable
    private Writer fileWriter;
    @Nullable
    private PrintWriter printWriter;
    @NotNull
    private final AtomicBoolean closed;
    private int maxFileSize;
    @NotNull
    private SimpleDateFormat dateFormat;
    private int checkSize;
    private boolean writingError;
    public static final int OFF = 0;
    public static final int ERROR = 1;
    public static final int WARN = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    private static int DEFAULT_LOG_LEVEL = 3;
    private static int DEFAULT_MAX_FILE_SIZE = 0x4000000;
    private static int CHECK_SIZE_EACH_WRITES = 4096;

    public MessageWriter(@NotNull Path path, int levelFile) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.levelFile = levelFile;
        this.log = LoggerFactory.getLogger(MessageWriter.class);
        this.closed = new AtomicBoolean();
        this.maxFileSize = DEFAULT_MAX_FILE_SIZE;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ");
    }

    public /* synthetic */ MessageWriter(Path path, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = DEFAULT_LOG_LEVEL;
        }
        this(path, n);
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    public final int getLevelFile() {
        return this.levelFile;
    }

    public final void setLevelFile(int n) {
        this.levelFile = n;
    }

    public final int getMaxFileSize() {
        return this.maxFileSize;
    }

    public final void setMaxFileSize(int n) {
        this.maxFileSize = n;
    }

    @NotNull
    public final SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public final void setDateFormat(@NotNull SimpleDateFormat simpleDateFormat) {
        Intrinsics.checkNotNullParameter((Object)simpleDateFormat, (String)"<set-?>");
        this.dateFormat = simpleDateFormat;
    }

    public final int getCheckSize() {
        return this.checkSize;
    }

    public final void setCheckSize(int n) {
        this.checkSize = n;
    }

    public final boolean getWritingError() {
        return this.writingError;
    }

    public final void setWritingError(boolean bl) {
        this.writingError = bl;
    }

    public final void write(@NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
        MessageWriter.writeFile$default(this, s2, null, 2, null);
    }

    public final void write(int level, @NotNull KClass<?> clazz, @NotNull String s2, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
        if (level > this.levelFile) {
            return;
        }
        String string = clazz.getSimpleName();
        this.write(level, string == null ? "" : string, s2, t);
    }

    public static /* synthetic */ void write$default(MessageWriter messageWriter, int n, KClass kClass, String string, Throwable throwable, int n2, Object object) {
        if ((n2 & 8) != 0) {
            throwable = null;
        }
        messageWriter.write(n, kClass, string, throwable);
    }

    public final void write(int level, @NotNull String module, @NotNull String s2, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
        if (level > this.levelFile) {
            return;
        }
        this.writeFile(this.format(module, s2), t);
    }

    public static /* synthetic */ void write$default(MessageWriter messageWriter, int n, String string, String string2, Throwable throwable, int n2, Object object) {
        if ((n2 & 8) != 0) {
            throwable = null;
        }
        messageWriter.write(n, string, string2, throwable);
    }

    private final synchronized String format(String module, String s2) {
        return this.dateFormat.format(System.currentTimeMillis()) + module + ": " + s2;
    }

    private final synchronized void writeFile(String s2, Throwable t) {
        try {
            Object old;
            MessageWriter messageWriter = this;
            int n = messageWriter.checkSize;
            messageWriter.checkSize = n + 1;
            if (n >= CHECK_SIZE_EACH_WRITES) {
                this.checkSize = 0;
                this.closeWriter();
                if (this.maxFileSize > 0 && Files.size(this.path) > (long)this.maxFileSize) {
                    old = Paths.get(this.path + ".old", new String[0]);
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    Files.move(this.path, (Path)old, copyOptionArray);
                }
            }
            if ((old = this.openWriter()) != null) {
                PrintWriter printWriter = old;
                boolean bl = false;
                boolean bl2 = false;
                PrintWriter it = printWriter;
                boolean bl3 = false;
                it.println(s2);
                Throwable throwable = t;
                if (throwable != null) {
                    throwable.printStackTrace(it);
                }
            }
        }
        catch (Exception e) {
            this.logWritingError(e);
        }
    }

    static /* synthetic */ void writeFile$default(MessageWriter messageWriter, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        messageWriter.writeFile(string, throwable);
    }

    private final void logWritingError(Exception e) {
        if (this.writingError) {
            return;
        }
        this.writingError = true;
        e.printStackTrace();
        this.writingError = false;
    }

    private final PrintWriter openWriter() {
        if (this.printWriter == null) {
            try {
                Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
                OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
                Writer writer = this.fileWriter = (Writer)Files.newBufferedWriter(this.path, openOptionArray);
                Intrinsics.checkNotNull((Object)writer);
                this.printWriter = new PrintWriter(writer, true);
            }
            catch (Exception e) {
                this.logWritingError(e);
                return null;
            }
        }
        return this.printWriter;
    }

    private final synchronized void closeWriter() {
        this.log.info("Closing writer | " + this.path);
        Writer writer = this.printWriter;
        if (writer != null) {
            ((PrintWriter)writer).flush();
        }
        writer = this.printWriter;
        if (writer != null) {
            ((PrintWriter)writer).close();
        }
        writer = this.fileWriter;
        if (writer != null) {
            writer.close();
        }
        this.printWriter = null;
        this.fileWriter = null;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.closeWriter();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0006\"\u0004\b\f\u0010\bR\u001a\u0010\r\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0006\"\u0004\b\u000f\u0010\bR\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lai/platon/pulsar/common/MessageWriter$Companion;", "", "()V", "CHECK_SIZE_EACH_WRITES", "", "getCHECK_SIZE_EACH_WRITES", "()I", "setCHECK_SIZE_EACH_WRITES", "(I)V", "DEBUG", "DEFAULT_LOG_LEVEL", "getDEFAULT_LOG_LEVEL", "setDEFAULT_LOG_LEVEL", "DEFAULT_MAX_FILE_SIZE", "getDEFAULT_MAX_FILE_SIZE", "setDEFAULT_MAX_FILE_SIZE", "ERROR", "INFO", "OFF", "WARN", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        public final int getDEFAULT_LOG_LEVEL() {
            return DEFAULT_LOG_LEVEL;
        }

        public final void setDEFAULT_LOG_LEVEL(int n) {
            DEFAULT_LOG_LEVEL = n;
        }

        public final int getDEFAULT_MAX_FILE_SIZE() {
            return DEFAULT_MAX_FILE_SIZE;
        }

        public final void setDEFAULT_MAX_FILE_SIZE(int n) {
            DEFAULT_MAX_FILE_SIZE = n;
        }

        public final int getCHECK_SIZE_EACH_WRITES() {
            return CHECK_SIZE_EACH_WRITES;
        }

        public final void setCHECK_SIZE_EACH_WRITES(int n) {
            CHECK_SIZE_EACH_WRITES = n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

