/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.ResourceLoader;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0003J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u00152\u0006\u0010\u0016\u001a\u00020\u0003J*\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00100\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lai/platon/pulsar/common/ResourceWalker;", "Ljava/lang/AutoCloseable;", "baseDir", "", "(Ljava/lang/String;)V", "getBaseDir", "()Ljava/lang/String;", "baseUri", "Ljava/net/URI;", "getBaseUri", "()Ljava/net/URI;", "fileSystem", "Ljava/nio/file/FileSystem;", "logger", "Lorg/slf4j/Logger;", "close", "", "getPath", "Ljava/nio/file/Path;", "resourceName", "list", "", "dir", "walk", "start", "maxDepth", "", "visitor", "Lkotlin/Function1;", "Companion", "pulsar-common"})
public final class ResourceWalker
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String baseDir;
    @NotNull
    private final Logger logger;
    @Nullable
    private final URI baseUri;
    @Nullable
    private FileSystem fileSystem;
    @NotNull
    private static final String SPRING_PACKED_RESOURCE_BASE_DIR = "BOOT-INF/classes/";
    @NotNull
    private static final ResourceWalker springPackedResourceWalker = new ResourceWalker(SPRING_PACKED_RESOURCE_BASE_DIR);

    public ResourceWalker(@NotNull String baseDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        this.baseDir = baseDir;
        this.logger = LogsKt.getLogger(this);
        URL uRL = ResourceLoader.INSTANCE.getResource(this.baseDir);
        this.baseUri = uRL == null ? null : uRL.toURI();
    }

    public /* synthetic */ ResourceWalker(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string);
    }

    @NotNull
    public final String getBaseDir() {
        return this.baseDir;
    }

    @Nullable
    public final URI getBaseUri() {
        return this.baseUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Path getPath(@NotNull String resourceName) {
        URI uRI;
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        String resource0 = this.baseDir + resourceName;
        Object object = ResourceLoader.INSTANCE.getResource(resource0);
        URI uRI2 = uRI = object == null ? null : ((URL)object).toURI();
        if (uRI == null) {
            return null;
        }
        URI uri = uRI;
        try {
            Path path;
            Object env;
            if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"jar")) {
                env = new HashMap();
                this.fileSystem = FileSystems.newFileSystem(uri, env);
                object = this.fileSystem;
                path = object == null ? null : ((FileSystem)object).getPath(resource0, new String[0]);
            } else {
                path = Paths.get(uri);
            }
            env = path;
            return env;
        }
        catch (Throwable t) {
            this.logger.warn("Unexpected failure get path | " + resource0, t);
        }
        return null;
    }

    @NotNull
    public final Set<Path> list(@NotNull String dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        boolean bl = false;
        Set paths = new LinkedHashSet();
        this.walk(dir, 1, (Function1<? super Path, Unit>)((Function1)new Function1<Path, Unit>(dir, (Set<Path>)paths){
            final /* synthetic */ String $dir;
            final /* synthetic */ Set<Path> $paths;
            {
                this.$dir = $dir;
                this.$paths = $paths;
                super(1);
            }

            public final void invoke(@NotNull Path it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!StringsKt.endsWith$default((String)((Object)it).toString(), (String)this.$dir, (boolean)false, (int)2, null)) {
                    this.$paths.add(it);
                }
            }
        }));
        return paths;
    }

    public final void walk(@NotNull String start2, int maxDepth, @NotNull Function1<? super Path, Unit> visitor) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        Path path = this.getPath(start2);
        Stream<Path> walk = Files.walk(path, maxDepth, new FileVisitOption[0]);
        Iterator it = walk.iterator();
        while (it.hasNext()) {
            try {
                Object t = it.next();
                Intrinsics.checkNotNullExpressionValue(t, (String)"it.next()");
                visitor.invoke(t);
            }
            catch (Exception e) {
                this.logger.warn("Failed to visit path | " + path, (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        FileSystem fileSystem = this.fileSystem;
        if (fileSystem != null) {
            fileSystem.close();
        }
    }

    public ResourceWalker() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/platon/pulsar/common/ResourceWalker$Companion;", "", "()V", "SPRING_PACKED_RESOURCE_BASE_DIR", "", "getSPRING_PACKED_RESOURCE_BASE_DIR", "()Ljava/lang/String;", "springPackedResourceWalker", "Lai/platon/pulsar/common/ResourceWalker;", "getSpringPackedResourceWalker", "()Lai/platon/pulsar/common/ResourceWalker;", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getSPRING_PACKED_RESOURCE_BASE_DIR() {
            return SPRING_PACKED_RESOURCE_BASE_DIR;
        }

        @NotNull
        public final ResourceWalker getSpringPackedResourceWalker() {
            return springPackedResourceWalker;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

