/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect.collector;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.collect.collector.DataCollector;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010#\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0006\b&\u0018\u0000 K*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001KB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010>\u001a\u00020\u00052\u0006\u0010?\u001a\u00020\u0005H\u0004J\b\u0010@\u001a\u00020AH\u0004J\b\u0010B\u001a\u00020AH\u0016J#\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00028\u00002\f\u0010E\u001a\b\u0012\u0004\u0012\u00028\u00000FH\u0016\u00a2\u0006\u0002\u0010GJ+\u0010C\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\u00052\u0006\u0010D\u001a\u00028\u00002\f\u0010E\u001a\b\u0012\u0004\u0012\u00028\u00000FH\u0016\u00a2\u0006\u0002\u0010IJ\u001e\u0010C\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\u00052\f\u0010E\u001a\b\u0012\u0004\u0012\u00028\u00000FH\u0016J\b\u0010J\u001a\u00020\u0014H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\u000bR\u001a\u0010\u0013\u001a\u00020\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001c\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0016\"\u0004\b#\u0010\u0018R\u0014\u0010$\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0007R\u0014\u0010&\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0007R\u0014\u0010(\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0007R\u001a\u0010*\u001a\u00020\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001c\"\u0004\b,\u0010 R\u0014\u0010-\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0007R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001400X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u001a\u00103\u001a\u00020\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0016\"\u0004\b5\u0010\u0018R\u001a\u00106\u001a\u00020\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u001c\"\u0004\b8\u0010 R\u001a\u00109\u001a\u00020\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u0016\"\u0004\b;\u0010\u0018R\u0014\u0010<\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u0007\u00a8\u0006L"}, d2={"Lai/platon/pulsar/common/collect/collector/AbstractDataCollector;", "E", "Lai/platon/pulsar/common/collect/collector/DataCollector;", "()V", "capacity", "", "getCapacity", "()I", "collectCount", "getCollectCount", "setCollectCount", "(I)V", "collectTime", "Ljava/time/Duration;", "getCollectTime", "()Ljava/time/Duration;", "collectedCount", "getCollectedCount", "setCollectedCount", "country", "", "getCountry", "()Ljava/lang/String;", "setCountry", "(Ljava/lang/String;)V", "createTime", "Ljava/time/Instant;", "getCreateTime", "()Ljava/time/Instant;", "deadTime", "getDeadTime", "setDeadTime", "(Ljava/time/Instant;)V", "district", "getDistrict", "setDistrict", "estimatedExternalSize", "getEstimatedExternalSize", "estimatedSize", "getEstimatedSize", "externalSize", "getExternalSize", "firstCollectTime", "getFirstCollectTime", "setFirstCollectTime", "id", "getId", "labels", "", "getLabels", "()Ljava/util/Set;", "lang", "getLang", "setLang", "lastCollectedTime", "getLastCollectedTime", "setLastCollectedTime", "name", "getName", "setName", "size", "getSize", "afterCollect", "collected", "beforeCollect", "", "clear", "collectTo", "element", "sink", "", "(Ljava/lang/Object;Ljava/util/List;)I", "index", "(ILjava/lang/Object;Ljava/util/List;)I", "toString", "Companion", "pulsar-common"})
public abstract class AbstractDataCollector<E>
implements DataCollector<E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int capacity;
    private final int id = idGen.incrementAndGet();
    @NotNull
    private String name = "DC";
    @NotNull
    private final Set<String> labels = new ConcurrentSkipListSet();
    @NotNull
    private String lang = "*";
    @NotNull
    private String country = "*";
    @NotNull
    private String district = "*";
    private final int externalSize;
    private int collectCount;
    private int collectedCount;
    @NotNull
    private final Instant createTime;
    @NotNull
    private Instant firstCollectTime;
    @NotNull
    private Instant lastCollectedTime;
    @NotNull
    private Instant deadTime;
    public static final int DEFAULT_CAPACITY = 1000;
    @NotNull
    private static final AtomicInteger idGen = new AtomicInteger();

    public AbstractDataCollector() {
        this.capacity = 1000;
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        this.createTime = instant;
        instant = Instant.EPOCH;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"EPOCH");
        this.firstCollectTime = instant;
        instant = Instant.EPOCH;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"EPOCH");
        this.lastCollectedTime = instant;
        instant = DateTimes.INSTANCE.getDoomsday();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"DateTimes.doomsday");
        this.deadTime = instant;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @Override
    @NotNull
    public Set<String> getLabels() {
        return this.labels;
    }

    @Override
    @NotNull
    public String getLang() {
        return this.lang;
    }

    public void setLang(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.lang = string;
    }

    @Override
    @NotNull
    public String getCountry() {
        return this.country;
    }

    public void setCountry(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.country = string;
    }

    @Override
    @NotNull
    public String getDistrict() {
        return this.district;
    }

    public void setDistrict(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.district = string;
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public int getExternalSize() {
        return this.externalSize;
    }

    @Override
    public int getEstimatedExternalSize() {
        return this.getExternalSize();
    }

    @Override
    public int getEstimatedSize() {
        return this.getSize() + this.getEstimatedExternalSize();
    }

    @Override
    public int getCollectCount() {
        return this.collectCount;
    }

    public void setCollectCount(int n) {
        this.collectCount = n;
    }

    @Override
    public int getCollectedCount() {
        return this.collectedCount;
    }

    public void setCollectedCount(int n) {
        this.collectedCount = n;
    }

    @Override
    @NotNull
    public Instant getCreateTime() {
        return this.createTime;
    }

    @Override
    @NotNull
    public Instant getFirstCollectTime() {
        return this.firstCollectTime;
    }

    public void setFirstCollectTime(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.firstCollectTime = instant;
    }

    @Override
    @NotNull
    public Instant getLastCollectedTime() {
        return this.lastCollectedTime;
    }

    public void setLastCollectedTime(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.lastCollectedTime = instant;
    }

    @Override
    @NotNull
    public Instant getDeadTime() {
        return this.deadTime;
    }

    public void setDeadTime(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.deadTime = instant;
    }

    @Override
    @NotNull
    public Duration getCollectTime() {
        Duration duration;
        if (this.getLastCollectedTime().compareTo(this.getFirstCollectTime()) > 0) {
            Duration duration2 = Duration.between(this.getFirstCollectTime(), this.getLastCollectedTime());
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"{\n            Duration.b\u2026tCollectedTime)\n        }");
            duration = duration2;
        } else {
            Duration duration3 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ZERO");
            duration = duration3;
        }
        return duration;
    }

    @Override
    public int collectTo(E element, @NotNull List<E> sink) {
        Intrinsics.checkNotNullParameter(sink, (String)"sink");
        int indexOfEnd = sink.isEmpty() ? 0 : sink.size() - 1;
        return this.collectTo(indexOfEnd, element, sink);
    }

    @Override
    public int collectTo(int index, E element, @NotNull List<E> sink) {
        Intrinsics.checkNotNullParameter(sink, (String)"sink");
        sink.add(index, element);
        return 1;
    }

    @Override
    public int collectTo(int index, @NotNull List<E> sink) {
        Intrinsics.checkNotNullParameter(sink, (String)"sink");
        boolean bl = false;
        List list2 = new ArrayList();
        this.collectTo(list2);
        sink.addAll(index, list2);
        return list2.size();
    }

    @Override
    public void clear() {
    }

    @NotNull
    public String toString() {
        long elapsedSeconds = RangesKt.coerceAtLeast((long)this.getCollectTime().getSeconds(), (long)1L);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s - collected %s/%s/%s/%s in %s, remaining %s/%s, collect time: %s -> %s %s";
        Object[] objectArray = new Object[11];
        objectArray[0] = this.getName();
        objectArray[1] = this.getCollectedCount();
        StringCompanionObject stringCompanionObject2 = StringCompanionObject.INSTANCE;
        String string2 = "%.2f";
        Object[] objectArray2 = new Object[]{1.0 * (double)this.getCollectedCount() / (double)elapsedSeconds};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"java.lang.String.format(format, *args)");
        objectArray[3] = this.getCollectCount();
        stringCompanionObject2 = StringCompanionObject.INSTANCE;
        string2 = "%.2f";
        objectArray2 = new Object[]{1.0 * (double)this.getCollectCount() / (double)elapsedSeconds};
        bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"java.lang.String.format(format, *args)");
        objectArray[5] = DateTimesKt.readable(this.getCollectTime());
        objectArray[6] = this.getSize();
        objectArray[7] = this.getEstimatedSize();
        objectArray[8] = this.getFirstCollectTime();
        objectArray[9] = this.getLastCollectedTime();
        objectArray[10] = CollectionsKt.joinToString$default((Iterable)this.getLabels(), null, null, null, (int)0, null, null, (int)63, null);
        boolean bl2 = false;
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        return string3;
    }

    protected final void beforeCollect() {
        Object object;
        if (Intrinsics.areEqual((Object)this.getFirstCollectTime(), (Object)Instant.EPOCH)) {
            object = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"now()");
            this.setFirstCollectTime((Instant)object);
        }
        object = this;
        ((AbstractDataCollector)object).setCollectCount(((AbstractDataCollector)object).getCollectCount() + 1);
        ((AbstractDataCollector)object).getCollectCount();
    }

    protected final int afterCollect(int collected) {
        Object object = this;
        ((AbstractDataCollector)object).setCollectedCount(((AbstractDataCollector)object).getCollectedCount() + collected);
        if (collected > 0) {
            object = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"now()");
            this.setLastCollectedTime((Instant)object);
        }
        return collected;
    }

    @Override
    public void deepClear() {
        DataCollector.DefaultImpls.deepClear(this);
    }

    @Override
    public boolean hasMore() {
        return DataCollector.DefaultImpls.hasMore(this);
    }

    @Override
    public boolean isDead() {
        return DataCollector.DefaultImpls.isDead(this);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lai/platon/pulsar/common/collect/collector/AbstractDataCollector$Companion;", "", "()V", "DEFAULT_CAPACITY", "", "idGen", "Ljava/util/concurrent/atomic/AtomicInteger;", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

