/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFSUtils {
    public static final Logger LOG = LoggerFactory.getLogger(LocalFSUtils.class);

    public static List<String> readAllLines(String path) throws IOException {
        return Files.readAllLines(Paths.get(path, new String[0]));
    }

    public static List<String> readAllLinesSilent(Path path) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                return Files.readAllLines(path);
            }
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, "".getBytes(), StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            LOG.warn(e.toString());
        }
        return Collections.emptyList();
    }
}

