/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.urls;

import ai.platon.pulsar.common.urls.StatefulFatLink;
import ai.platon.pulsar.common.urls.StatefulHyperlink;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u0006\u0010$\u001a\u00020%J\u0018\u0010&\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\f2\b\b\u0002\u0010'\u001a\u00020\u0006J\b\u0010(\u001a\u00020\u0003H\u0016R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0019\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0011R\u0011\u0010\u001f\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0011R\u0016\u0010 \u001a\n \u001b*\u0004\u0018\u00010!0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0016\u00a8\u0006)"}, d2={"Lai/platon/pulsar/common/urls/CrawlableFatLink;", "Lai/platon/pulsar/common/urls/StatefulFatLink;", "url", "", "text", "order", "", "referer", "args", "href", "tailLinks", "", "Lai/platon/pulsar/common/urls/StatefulHyperlink;", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "aborted", "", "getAborted", "()Z", "setAborted", "(Z)V", "finishedTailLinkCount", "getFinishedTailLinkCount", "()I", "setFinishedTailLinkCount", "(I)V", "idleTime", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getIdleTime", "()Ljava/time/Duration;", "isAborted", "isFinished", "log", "Lorg/slf4j/Logger;", "numActive", "getNumActive", "abort", "", "finish", "status", "toString", "pulsar-common"})
public class CrawlableFatLink
extends StatefulFatLink {
    private final Logger log;
    private volatile int finishedTailLinkCount;
    private boolean aborted;

    public CrawlableFatLink(@NotNull String url, @NotNull String text, int order, @Nullable String referer, @Nullable String args, @Nullable String href, @NotNull List<? extends StatefulHyperlink> tailLinks) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(tailLinks, (String)"tailLinks");
        super(url, text, order, referer, args, href, tailLinks);
        this.log = LoggerFactory.getLogger(CrawlableFatLink.class);
    }

    public /* synthetic */ CrawlableFatLink(String string, String string2, int n, String string3, String string4, String string5, List list2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            string3 = null;
        }
        if ((n2 & 0x10) != 0) {
            string4 = null;
        }
        if ((n2 & 0x20) != 0) {
            string5 = null;
        }
        if ((n2 & 0x40) != 0) {
            boolean bl = false;
            list2 = CollectionsKt.emptyList();
        }
        this(string, string2, n, string3, string4, string5, list2);
    }

    public final int getFinishedTailLinkCount() {
        return this.finishedTailLinkCount;
    }

    public final void setFinishedTailLinkCount(int n) {
        this.finishedTailLinkCount = n;
    }

    public final boolean getAborted() {
        return this.aborted;
    }

    public final void setAborted(boolean bl) {
        this.aborted = bl;
    }

    public final int getNumActive() {
        return this.getSize() - this.finishedTailLinkCount;
    }

    public final boolean isAborted() {
        return this.aborted;
    }

    public final boolean isFinished() {
        return this.finishedTailLinkCount >= this.getSize();
    }

    public final Duration getIdleTime() {
        return Duration.between(this.getModifiedAt(), Instant.now());
    }

    public final void abort() {
        this.aborted = true;
    }

    public final boolean finish(@NotNull StatefulHyperlink url, int status) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.aborted = false;
            if (this.log.isDebugEnabled()) {
                Object[] objectArray = new Object[]{this.getTailLinks().contains(url) ? "found" : "not found", url, this};
                this.log.debug("Try to finish stateful hyperlink, ({}) \n{} \n{}", objectArray);
            }
            Iterable $this$none$iv = this.getTailLinks();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    StatefulHyperlink it = (StatefulHyperlink)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)url.getUrl(), (Object)it.getUrl())) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (bl) {
            return false;
        }
        boolean bl3 = Intrinsics.areEqual((Object)url.getReferrer(), (Object)this.getUrl());
        boolean bl4 = false;
        boolean bl5 = false;
        bl5 = false;
        boolean bl6 = false;
        if (!bl3) {
            boolean bl7 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Comparable<Instant> comparable = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"now()");
        url.setModifiedAt((Instant)comparable);
        url.setStatus(status);
        comparable = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"now()");
        this.setModifiedAt((Instant)comparable);
        comparable = this;
        ++((CrawlableFatLink)comparable).finishedTailLinkCount;
        int cfr_ignored_0 = ((CrawlableFatLink)comparable).finishedTailLinkCount;
        if (this.isFinished()) {
            this.log.info("Crawlable fat link is finished | {}", (Object)this);
            this.setStatus(200);
        }
        return true;
    }

    public static /* synthetic */ boolean finish$default(CrawlableFatLink crawlableFatLink, StatefulHyperlink statefulHyperlink, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: finish");
        }
        if ((n2 & 2) != 0) {
            n = 200;
        }
        return crawlableFatLink.finish(statefulHyperlink, n);
    }

    @Override
    @NotNull
    public String toString() {
        return this.finishedTailLinkCount + "/" + this.getTailLinks().size() + " " + super.toString();
    }
}

