/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u001a\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\nJ\u0010\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\nJ\u0006\u0010\u0013\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"LJarTool;", "", "()V", "manifest", "Ljava/util/jar/Manifest;", "addFile", "", "target", "Ljava/util/jar/JarOutputStream;", "rootPath", "", "source", "addToManifest", "key", "value", "openJar", "jarFile", "setMainClass", "mainFQCN", "startManifest", "pulsar-common"})
public final class JarTool {
    @NotNull
    private final Manifest manifest = new Manifest();

    public final void startManifest() {
        Map<Object, Object> map = this.manifest.getMainAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"manifest.mainAttributes");
        map = map;
        Attributes.Name name = Attributes.Name.MANIFEST_VERSION;
        String string = "1.0";
        boolean bl = false;
        map.put(name, string);
    }

    public final void setMainClass(@Nullable String mainFQCN) {
        if (mainFQCN != null && !Intrinsics.areEqual((Object)mainFQCN, (Object)"")) {
            Map<Object, Object> map = this.manifest.getMainAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"manifest.mainAttributes");
            map = map;
            Attributes.Name name = Attributes.Name.MAIN_CLASS;
            boolean bl = false;
            map.put(name, mainFQCN);
        }
    }

    public final void addToManifest(@Nullable String key, @Nullable String value) {
        Map<Object, Object> map = this.manifest.getMainAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"manifest.mainAttributes");
        map = map;
        Attributes.Name name = new Attributes.Name(key);
        boolean bl = false;
        map.put(name, value);
    }

    @NotNull
    public final JarOutputStream openJar(@NotNull String jarFile) throws IOException {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        return new JarOutputStream((OutputStream)new FileOutputStream(jarFile), this.manifest);
    }

    public final void addFile(@NotNull JarOutputStream target, @NotNull String rootPath, @NotNull String source) throws FileNotFoundException, IOException {
        int count;
        String string;
        boolean bl;
        int n;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String string2 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
        if (StringsKt.endsWith$default((String)rootPath, (String)string2, (boolean)false, (int)2, null)) {
            string2 = source;
            n = rootPath.length();
            bl = false;
            String string3 = string2.substring(n);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string2 = source;
            n = rootPath.length() + 1;
            bl = false;
            String string4 = string2.substring(n);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        }
        String remaining = string;
        String name = StringsKt.replace$default((String)remaining, (String)"\\", (String)"/", (boolean)false, (int)4, null);
        JarEntry entry = new JarEntry(name);
        entry.setTime(new File(source).lastModified());
        target.putNextEntry(entry);
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(source));
        byte[] buffer = new byte[1024];
        while ((count = bis.read(buffer)) != -1) {
            target.write(buffer, 0, count);
        }
        target.closeEntry();
        bis.close();
    }
}

