/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.MessageWriter;
import ai.platon.pulsar.common.config.ImmutableConfig;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u000eJ\u0016\u0010 \u001a\n \u0010*\u0004\u0018\u00010\u00070\u00072\u0006\u0010\u001f\u001a\u00020\u000eJ\u0016\u0010!\u001a\n \u0010*\u0004\u0018\u00010\u00070\u00072\u0006\u0010\u001f\u001a\u00020\u000eJ\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0#2\u0006\u0010\u001f\u001a\u00020\u000eJ\u0016\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u0007J\u0016\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000eJ\u0016\u0010'\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u0007J\u0016\u0010'\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000eR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\n \u0010*\u0004\u0018\u00010\u00070\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006("}, d2={"Lai/platon/pulsar/common/MultiSinkWriter;", "Ljava/lang/AutoCloseable;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "_writers", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/file/Path;", "Lai/platon/pulsar/common/MessageWriter;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "jobIdent", "", "reportDir", "kotlin.jvm.PlatformType", "getReportDir", "()Ljava/nio/file/Path;", "reportDir0", "getReportDir0", "timeIdent", "getTimeIdent", "()Ljava/lang/String;", "writers", "", "getWriters", "()Ljava/util/Map;", "close", "", "closeWriter", "filename", "getPath", "pathOf", "readAllLines", "", "write", "message", "file", "writeLine", "pulsar-common"})
public abstract class MultiSinkWriter
implements AutoCloseable {
    @NotNull
    private final ImmutableConfig conf;
    @Nullable
    private final String jobIdent;
    @NotNull
    private final ConcurrentHashMap<Path, MessageWriter> _writers;
    @NotNull
    private final AtomicBoolean closed;
    private final Path reportDir;

    public MultiSinkWriter(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.jobIdent = this.conf.get("pulsar.job.name");
        this._writers = new ConcurrentHashMap();
        this.closed = new AtomicBoolean();
        this.reportDir = this.jobIdent == null ? this.getReportDir0() : this.getReportDir0().resolve(this.jobIdent);
        Files.createDirectories(this.reportDir, new FileAttribute[0]);
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    private final String getTimeIdent() {
        return DateTimes.INSTANCE.formatNow("MMdd");
    }

    private final Path getReportDir0() {
        return AppPaths.INSTANCE.getREPORT_DIR().resolve(this.getTimeIdent());
    }

    @NotNull
    public final Map<Path, MessageWriter> getWriters() {
        return this._writers;
    }

    public final Path getReportDir() {
        return this.reportDir;
    }

    public final Path getPath(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return this.pathOf(filename);
    }

    public final Path pathOf(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return this.reportDir.resolve(filename);
    }

    @NotNull
    public final List<String> readAllLines(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Path path = this.getPath(filename);
        if (Files.exists(path, new LinkOption[0])) {
            List<String> list2 = Files.readAllLines(path);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"readAllLines(path)");
            return list2;
        }
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    public final void write(@NotNull String message, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Path path = this.getPath(filename);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(filename)");
        this.write(message, path);
    }

    public final void write(@NotNull String message, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this._writers.computeIfAbsent(file.toAbsolutePath(), MultiSinkWriter::write$lambda-0).write(message);
    }

    public final void writeLine(@NotNull String message, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Path path = this.getPath(filename);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(filename)");
        this.writeLine(message, path);
    }

    public final void writeLine(@NotNull String message, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MessageWriter messageWriter = this._writers.computeIfAbsent(file.toAbsolutePath(), MultiSinkWriter::writeLine$lambda-1);
        Intrinsics.checkNotNullExpressionValue((Object)messageWriter, (String)"_writers.computeIfAbsent\u2026()) { MessageWriter(it) }");
        MessageWriter writer = messageWriter;
        writer.write(message);
        writer.write("\n");
    }

    public final void closeWriter(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        MessageWriter messageWriter = this._writers.get(this.getPath(filename));
        if (messageWriter != null) {
            messageWriter.close();
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Collection<MessageWriter> collection = this._writers.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"_writers.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MessageWriter it = (MessageWriter)element$iv;
                boolean bl = false;
                it.close();
            }
        }
    }

    private static final MessageWriter write$lambda-0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new MessageWriter(it, 0, 2, null);
    }

    private static final MessageWriter writeLine$lambda-1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new MessageWriter(it, 0, 2, null);
    }
}

