/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.MessageWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00132\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0003J\u0016\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0003J\u0016\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lai/platon/pulsar/common/MultiMessageWriter;", "Ljava/lang/AutoCloseable;", "baseDir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getBaseDir", "()Ljava/nio/file/Path;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "writers", "Ljava/util/concurrent/ConcurrentHashMap;", "Lai/platon/pulsar/common/MessageWriter;", "close", "", "closeWriter", "filename", "", "getPath", "readAllLines", "", "write", "message", "path", "writeLine", "pulsar-common"})
public abstract class MultiMessageWriter
implements AutoCloseable {
    @NotNull
    private final Path baseDir;
    @NotNull
    private final ConcurrentHashMap<Path, MessageWriter> writers;
    @NotNull
    private final AtomicBoolean closed;

    public MultiMessageWriter(@NotNull Path baseDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        this.baseDir = baseDir;
        this.writers = new ConcurrentHashMap();
        this.closed = new AtomicBoolean();
    }

    @NotNull
    public final Path getBaseDir() {
        return this.baseDir;
    }

    @NotNull
    public final Path getPath(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Path path = this.baseDir.resolve(filename);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"baseDir.resolve(filename)");
        return path;
    }

    @NotNull
    public final List<String> readAllLines(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Path path = this.getPath(filename);
        if (Files.exists(path, new LinkOption[0])) {
            List<String> list2 = Files.readAllLines(path);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"readAllLines(path)");
            return list2;
        }
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    public final void write(@NotNull String message, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.write(message, this.getPath(filename));
    }

    public final void write(@NotNull String message, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.writers.computeIfAbsent(path.toAbsolutePath(), MultiMessageWriter::write$lambda-0).write(message);
    }

    public final void writeLine(@NotNull String message, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.writeLine(message, this.getPath(filename));
    }

    public final void writeLine(@NotNull String message, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        MessageWriter messageWriter = this.writers.computeIfAbsent(path.toAbsolutePath(), MultiMessageWriter::writeLine$lambda-1);
        Intrinsics.checkNotNullExpressionValue((Object)messageWriter, (String)"writers.computeIfAbsent(\u2026()) { MessageWriter(it) }");
        MessageWriter writer = messageWriter;
        writer.write(message);
        writer.write("\n");
    }

    public final void closeWriter(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        MessageWriter messageWriter = this.writers.get(this.getPath(filename));
        if (messageWriter != null) {
            messageWriter.close();
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Collection<MessageWriter> collection = this.writers.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"writers.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MessageWriter it = (MessageWriter)element$iv;
                boolean bl = false;
                it.close();
            }
        }
    }

    private static final MessageWriter write$lambda-0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new MessageWriter(it, 0, 2, null);
    }

    private static final MessageWriter writeLine$lambda-1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new MessageWriter(it, 0, 2, null);
    }
}

