/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.proxy;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.LangKt;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.proxy.ProxyEntry;
import ai.platon.pulsar.common.proxy.ProxyException;
import ai.platon.pulsar.common.proxy.ProxyPool;
import ai.platon.pulsar.common.proxy.ProxyRetryException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010)\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010,\u001a\u00020-J\b\u0010.\u001a\u00020-H\u0016J\u0011\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u000fH\u0086\u0002J\b\u00101\u001a\u00020-H\u0016J\u001e\u00101\u001a\u00020-2\u0006\u00102\u001a\u0002032\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f04H\u0004J\u0006\u00105\u001a\u00020\u0013J\u000f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000f07H\u0086\u0002J\u0010\u00108\u001a\u00020\u00132\u0006\u00109\u001a\u00020\u000fH\u0016J\u0010\u0010:\u001a\u00020-2\u0006\u00109\u001a\u00020\u000fH\u0016J\u0010\u0010;\u001a\u00020-2\u0006\u00109\u001a\u00020\u000fH\u0016J\n\u0010<\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010=\u001a\u00020>H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\"\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\n \u0017*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\b\"\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0'X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\b\u00a8\u0006?"}, d2={"Lai/platon/pulsar/common/proxy/ProxyPool;", "Ljava/lang/AutoCloseable;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "capacity", "", "getCapacity", "()I", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getClosed", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "freeProxies", "Ljava/util/concurrent/LinkedBlockingDeque;", "Lai/platon/pulsar/common/proxy/ProxyEntry;", "getFreeProxies", "()Ljava/util/concurrent/LinkedBlockingDeque;", "isActive", "", "()Z", "lastActiveTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "getLastActiveTime", "()Ljava/time/Instant;", "setLastActiveTime", "(Ljava/time/Instant;)V", "logger", "Lorg/slf4j/Logger;", "numProxyBanned", "getNumProxyBanned", "setNumProxyBanned", "(I)V", "pollingTimeout", "Ljava/time/Duration;", "getPollingTimeout", "()Ljava/time/Duration;", "proxyEntries", "", "getProxyEntries", "()Ljava/util/Set;", "size", "getSize", "clear", "", "close", "contains", "element", "dump", "path", "Ljava/nio/file/Path;", "", "isEmpty", "iterator", "", "offer", "proxyEntry", "report", "retire", "take", "toString", "", "pulsar-common"})
public class ProxyPool
implements AutoCloseable {
    private final Logger logger;
    private final int capacity;
    @NotNull
    private final Duration pollingTimeout;
    @NotNull
    private final Set<ProxyEntry> proxyEntries;
    @NotNull
    private final LinkedBlockingDeque<ProxyEntry> freeProxies;
    private int numProxyBanned;
    @NotNull
    private final AtomicBoolean closed;
    private Instant lastActiveTime;

    public ProxyPool(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.logger = LoggerFactory.getLogger(ProxyPool.class);
        this.capacity = conf.getInt("proxy.pool.size", 100);
        Duration duration = Duration.ofSeconds(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(1)");
        Duration duration2 = conf.getDuration("proxy.pool.polling.interval", duration);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"conf.getDuration(PROXY_P\u2026T, Duration.ofSeconds(1))");
        this.pollingTimeout = duration2;
        boolean bl = false;
        this.proxyEntries = new LinkedHashSet();
        this.freeProxies = new LinkedBlockingDeque(this.capacity);
        this.closed = new AtomicBoolean();
        this.lastActiveTime = Instant.now();
    }

    protected final int getCapacity() {
        return this.capacity;
    }

    @NotNull
    protected final Duration getPollingTimeout() {
        return this.pollingTimeout;
    }

    @NotNull
    protected final Set<ProxyEntry> getProxyEntries() {
        return this.proxyEntries;
    }

    @NotNull
    protected final LinkedBlockingDeque<ProxyEntry> getFreeProxies() {
        return this.freeProxies;
    }

    protected final int getNumProxyBanned() {
        return this.numProxyBanned;
    }

    protected final void setNumProxyBanned(int n) {
        this.numProxyBanned = n;
    }

    @NotNull
    protected final AtomicBoolean getClosed() {
        return this.closed;
    }

    public final boolean isActive() {
        return !this.closed.get() && AppContext.INSTANCE.isActive();
    }

    public final Instant getLastActiveTime() {
        return this.lastActiveTime;
    }

    public final void setLastActiveTime(Instant instant) {
        this.lastActiveTime = instant;
    }

    public final boolean contains(@NotNull ProxyEntry element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.freeProxies.contains(element);
    }

    @NotNull
    public final Iterator<ProxyEntry> iterator() {
        Iterator<ProxyEntry> iterator = this.freeProxies.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"freeProxies.iterator()");
        return iterator;
    }

    public final int getSize() {
        return this.freeProxies.size();
    }

    public final boolean isEmpty() {
        return this.freeProxies.isEmpty();
    }

    public final void clear() {
        this.freeProxies.clear();
    }

    public boolean offer(@NotNull ProxyEntry proxyEntry) {
        Intrinsics.checkNotNullParameter((Object)proxyEntry, (String)"proxyEntry");
        this.proxyEntries.add(proxyEntry);
        return this.freeProxies.offer(proxyEntry);
    }

    @Nullable
    public ProxyEntry take() throws ProxyException {
        this.lastActiveTime = Instant.now();
        int retry = 30;
        while (true) {
            int n = retry;
            retry = n + -1;
            if (n <= 0 || Thread.currentThread().isInterrupted()) break;
            try {
                return this.freeProxies.poll(this.pollingTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (ProxyRetryException e) {
                LangKt.sleepSeconds(1L);
                continue;
            }
            break;
        }
        return null;
    }

    public void retire(@NotNull ProxyEntry proxyEntry) {
        Intrinsics.checkNotNullParameter((Object)proxyEntry, (String)"proxyEntry");
        proxyEntry.retire();
    }

    public void report(@NotNull ProxyEntry proxyEntry) {
        Intrinsics.checkNotNullParameter((Object)proxyEntry, (String)"proxyEntry");
        Object[] objectArray = new Object[5];
        objectArray[0] = proxyEntry.getOutIp();
        objectArray[1] = proxyEntry.getNumSuccessPages();
        Duration duration = proxyEntry.getElapsedTime();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"proxyEntry.elapsedTime");
        objectArray[2] = DateTimesKt.readable(duration);
        objectArray[3] = this.numProxyBanned;
        objectArray[4] = proxyEntry;
        this.logger.info("Ban proxy <{}> after {} pages served in {} | total ban: {} | {}", objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        if (this.proxyEntries.isEmpty()) {
            this.logger.info("Used total 0 proxies, do not dump");
            return;
        }
        Path path = AppPaths.INSTANCE.getPROXY_ARCHIVE_DIR();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"AppPaths.PROXY_ARCHIVE_DIR");
        boolean bl = false;
        boolean bl2 = false;
        synchronized (path) {
            boolean bl3 = false;
            try {
                String ident = DateTimes.INSTANCE.now("MMdd.HH");
                Path currentArchiveDir = AppPaths.INSTANCE.getPROXY_ARCHIVE_DIR().resolve(ident);
                Files.createDirectories(currentArchiveDir, new FileAttribute[0]);
                Path path2 = currentArchiveDir.resolve("proxies.all.txt");
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"currentArchiveDir.resolve(\"proxies.all.txt\")");
                this.dump(path2, (Collection<ProxyEntry>)this.getProxyEntries());
                this.logger.info("Proxy pool is dumped to file://{} | {}", (Object)currentArchiveDir, (Object)this);
            }
            catch (IOException e) {
                this.logger.warn(e.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public String toString() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "total %d, free: %d";
        Object[] objectArray = new Object[]{this.proxyEntries.size(), this.freeProxies.size()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Collection collection = this.proxyEntries;
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.dump();
            }
        }
    }

    protected final void dump(@NotNull Path path, @NotNull Collection<ProxyEntry> proxyEntries) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(proxyEntries, (String)"proxyEntries");
        String content2 = CollectionsKt.joinToString$default((Iterable)proxyEntries, (CharSequence)"\n", null, null, (int)0, null, (Function1)dump.content.1.INSTANCE, (int)30, null);
        try {
            Files.deleteIfExists(path);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE_NEW};
            Files.writeString(path, (CharSequence)content2, openOptionArray);
        }
        catch (IOException e) {
            this.logger.warn(e.toString());
        }
    }
}

