/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect;

import ai.platon.pulsar.common.urls.UrlAware;
import com.google.common.primitives.Ints;
import java.time.Duration;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010\u0007\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lai/platon/pulsar/common/collect/DelayUrl;", "Ljava/util/concurrent/Delayed;", "url", "Lai/platon/pulsar/common/urls/UrlAware;", "delay", "Ljava/time/Duration;", "(Lai/platon/pulsar/common/urls/UrlAware;Ljava/time/Duration;)V", "getDelay", "()Ljava/time/Duration;", "delayExpireAt", "", "getDelayExpireAt", "()J", "startTime", "getStartTime$annotations", "()V", "getStartTime", "getUrl", "()Lai/platon/pulsar/common/urls/UrlAware;", "compareTo", "", "other", "unit", "Ljava/util/concurrent/TimeUnit;", "pulsar-common"})
public class DelayUrl
implements Delayed {
    @NotNull
    private final UrlAware url;
    @NotNull
    private final Duration delay;
    private final long delayExpireAt;

    public DelayUrl(@NotNull UrlAware url, @NotNull Duration delay) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        this.url = url;
        this.delay = delay;
        this.delayExpireAt = System.currentTimeMillis() + this.delay.toMillis();
    }

    @NotNull
    public final UrlAware getUrl() {
        return this.url;
    }

    @NotNull
    public final Duration getDelay() {
        return this.delay;
    }

    public final long getDelayExpireAt() {
        return this.delayExpireAt;
    }

    public final long getStartTime() {
        return this.delayExpireAt;
    }

    @Deprecated(message="Inappropriate name", replaceWith=@ReplaceWith(expression="delayExpires", imports={}))
    public static /* synthetic */ void getStartTime$annotations() {
    }

    @Override
    public int compareTo(@NotNull Delayed other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Ints.saturatedCast((long)(this.delayExpireAt - ((DelayUrl)other).delayExpireAt));
    }

    @Override
    public long getDelay(@NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        long diff = this.delayExpireAt - System.currentTimeMillis();
        return unit.convert(diff, TimeUnit.MILLISECONDS);
    }
}

