/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.FileCommand;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\b\b\u0002\u0010\u0017\u001a\u00020\u00042\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0007J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lai/platon/pulsar/common/FileCommand;", "", "()V", "CHECK_INTERVAL", "Ljava/time/Duration;", "getCHECK_INTERVAL", "()Ljava/time/Duration;", "COMMAND_FILE", "Ljava/nio/file/Path;", "getCOMMAND_FILE", "()Ljava/nio/file/Path;", "LAST_CHECK_TIME", "", "", "", "getLAST_CHECK_TIME", "()Ljava/util/Map;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "check", "", "command", "checkInterval", "action", "Lkotlin/Function0;", "", "pulsar-common"})
public final class FileCommand {
    @NotNull
    public static final FileCommand INSTANCE = new FileCommand();
    private static final Logger log = LoggerFactory.getLogger(FileCommand.class);
    @NotNull
    private static final Path COMMAND_FILE;
    @NotNull
    private static final Duration CHECK_INTERVAL;
    @NotNull
    private static final Map<String, Long> LAST_CHECK_TIME;

    private FileCommand() {
    }

    @NotNull
    public final Path getCOMMAND_FILE() {
        return COMMAND_FILE;
    }

    @NotNull
    public final Duration getCHECK_INTERVAL() {
        return CHECK_INTERVAL;
    }

    @NotNull
    public final Map<String, Long> getLAST_CHECK_TIME() {
        return LAST_CHECK_TIME;
    }

    public final boolean check(@NotNull String command, long checkInterval) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Duration duration = Duration.ofSeconds(checkInterval);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(checkInterval)");
        return FileCommand.check$default(this, command, duration, null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final boolean check(@NotNull String command, @NotNull Duration checkInterval, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)checkInterval, (String)"checkInterval");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (!Files.exists(COMMAND_FILE, new LinkOption[0])) {
            return false;
        }
        boolean exist = false;
        try {
            Class<FileCommand> clazz = FileCommand.class;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (clazz) {
                boolean bl3 = false;
                long modifiedTime = INSTANCE.getCOMMAND_FILE().toFile().lastModified();
                long lastCheckTime = ((Number)INSTANCE.getLAST_CHECK_TIME().getOrDefault(command, 0L)).longValue();
                long now = System.currentTimeMillis();
                if (lastCheckTime <= modifiedTime && now - lastCheckTime >= checkInterval.toMillis()) {
                    boolean bl4;
                    boolean bl5;
                    List<String> lines;
                    block12: {
                        Map<String, Long> map = INSTANCE.getLAST_CHECK_TIME();
                        Long l = now;
                        boolean bl6 = false;
                        map.put(command, l);
                        lines = Files.readAllLines(INSTANCE.getCOMMAND_FILE());
                        Intrinsics.checkNotNullExpressionValue(lines, (String)"lines");
                        Iterable $this$any$iv = lines;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl5 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                String it = (String)element$iv;
                                boolean bl7 = false;
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                if (!StringsKt.contains$default((CharSequence)it, (CharSequence)command, (boolean)false, (int)2, null)) continue;
                                bl5 = true;
                                break block12;
                            }
                            bl5 = false;
                        }
                    }
                    exist = bl4 = bl5;
                    if (exist) {
                        if (!StringsKt.contains((CharSequence)command, (CharSequence)"-perm", (boolean)true)) {
                            lines.remove(command);
                            Files.write(INSTANCE.getCOMMAND_FILE(), (Iterable<? extends CharSequence>)lines, new OpenOption[0]);
                        }
                        action.invoke();
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return exist;
    }

    public static /* synthetic */ boolean check$default(FileCommand fileCommand, String string, Duration duration, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            duration = CHECK_INTERVAL;
        }
        if ((n & 4) != 0) {
            function0 = check.1.INSTANCE;
        }
        return fileCommand.check(string, duration, (Function0<Unit>)function0);
    }

    @JvmOverloads
    public final boolean check(@NotNull String command, @NotNull Duration checkInterval) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)checkInterval, (String)"checkInterval");
        return FileCommand.check$default(this, command, checkInterval, null, 4, null);
    }

    @JvmOverloads
    public final boolean check(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return FileCommand.check$default(this, command, null, null, 6, null);
    }

    static {
        Comparable<Path> comparable = AppPaths.INSTANCE.getPATH_LOCAL_COMMAND();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"AppPaths.PATH_LOCAL_COMMAND");
        COMMAND_FILE = comparable;
        comparable = Duration.ofSeconds(15L);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"ofSeconds(15)");
        CHECK_INTERVAL = comparable;
        LAST_CHECK_TIME = new HashMap();
    }
}

