/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect.queue;

import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.collect.ExternalUrlLoader;
import ai.platon.pulsar.common.collect.UrlTopic;
import ai.platon.pulsar.common.collect.queue.LoadingQueue;
import ai.platon.pulsar.common.urls.UrlAware;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010)\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u0002H\u0016J\u0016\u00106\u001a\u00020\u001f2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J\b\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u000209H\u0016J\u0006\u0010;\u001a\u000209J\u000f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00020=H\u0096\u0002J\b\u0010>\u001a\u000209H\u0016J\u000e\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J\u0010\u0010@\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u0002H\u0016J\u0010\u0010A\u001a\u0002092\u0006\u00105\u001a\u00020\u0002H\u0016J\u0016\u0010A\u001a\u0002092\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00020BH\u0016J\n\u0010C\u001a\u0004\u0018\u00010\u0002H\u0016J\n\u0010D\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010E\u001a\u00020\u0000H\u0002J\u0018\u0010F\u001a\u00020\u001f2\u000e\u0010G\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020HH\u0016J\b\u0010I\u001a\u000209H\u0016R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017R\u0011\u0010\u001c\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0017R\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 R$\u0010\"\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0014@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0017\"\u0004\b$\u0010%R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0016\u0010(\u001a\n **\u0004\u0018\u00010)0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010+\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0014@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0017\"\u0004\b-\u0010%R\u0014\u0010.\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u0006J"}, d2={"Lai/platon/pulsar/common/collect/queue/AbstractLoadingQueue;", "Ljava/util/AbstractQueue;", "Lai/platon/pulsar/common/urls/UrlAware;", "Lai/platon/pulsar/common/collect/queue/LoadingQueue;", "loader", "Lai/platon/pulsar/common/collect/ExternalUrlLoader;", "topic", "Lai/platon/pulsar/common/collect/UrlTopic;", "transformer", "Lkotlin/Function1;", "(Lai/platon/pulsar/common/collect/ExternalUrlLoader;Lai/platon/pulsar/common/collect/UrlTopic;Lkotlin/jvm/functions/Function1;)V", "cache", "", "getCache", "()Ljava/util/Collection;", "cacheImplementation", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "getCacheImplementation", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "capacity", "", "estimatedExternalSize", "getEstimatedExternalSize", "()I", "estimatedSize", "getEstimatedSize", "externalSize", "getExternalSize", "freeSlots", "getFreeSlots", "isFull", "", "()Z", "<set-?>", "loadCount", "getLoadCount", "setLoadCount", "(I)V", "getLoader", "()Lai/platon/pulsar/common/collect/ExternalUrlLoader;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "savedCount", "getSavedCount", "setSavedCount", "size", "getSize", "getTopic", "()Lai/platon/pulsar/common/collect/UrlTopic;", "getTransformer", "()Lkotlin/jvm/functions/Function1;", "add", "url", "addAll", "urls", "clear", "", "deepClear", "externalClear", "iterator", "", "load", "loadNow", "offer", "overflow", "", "peek", "poll", "refreshIfNecessary", "removeIf", "filter", "Ljava/util/function/Predicate;", "shuffle", "pulsar-common"})
public abstract class AbstractLoadingQueue
extends AbstractQueue<UrlAware>
implements LoadingQueue<UrlAware> {
    @NotNull
    private final ExternalUrlLoader loader;
    @NotNull
    private final UrlTopic topic;
    @NotNull
    private final Function1<UrlAware, UrlAware> transformer;
    private final Logger logger;
    @NotNull
    private final ConcurrentLinkedQueue<UrlAware> cacheImplementation;
    private final int capacity;
    private int loadCount;
    private int savedCount;
    @NotNull
    private final Collection<UrlAware> cache;

    public AbstractLoadingQueue(@NotNull ExternalUrlLoader loader, @NotNull UrlTopic topic, @NotNull Function1<? super UrlAware, ? extends UrlAware> transformer) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        this.loader = loader;
        this.topic = topic;
        this.transformer = transformer;
        this.logger = LogsKt.getLogger(Reflection.getOrCreateKotlinClass(AbstractLoadingQueue.class));
        this.cacheImplementation = new ConcurrentLinkedQueue();
        this.capacity = this.topic.getPageSize();
        this.cache = this.cacheImplementation;
    }

    @NotNull
    public final ExternalUrlLoader getLoader() {
        return this.loader;
    }

    @NotNull
    public final UrlTopic getTopic() {
        return this.topic;
    }

    @NotNull
    public final Function1<UrlAware, UrlAware> getTransformer() {
        return this.transformer;
    }

    @NotNull
    protected final ConcurrentLinkedQueue<UrlAware> getCacheImplementation() {
        return this.cacheImplementation;
    }

    public final int getLoadCount() {
        return this.loadCount;
    }

    protected final void setLoadCount(int n) {
        this.loadCount = n;
    }

    public final int getSavedCount() {
        return this.savedCount;
    }

    protected final void setSavedCount(int n) {
        this.savedCount = n;
    }

    @NotNull
    public final Collection<UrlAware> getCache() {
        return this.cache;
    }

    public synchronized int getSize() {
        return this.cacheImplementation.size();
    }

    @Override
    public synchronized int getExternalSize() {
        Object object;
        ExternalUrlLoader externalUrlLoader = this.loader;
        boolean bl = false;
        try {
            object = Result.Companion;
            ExternalUrlLoader $this$_get_externalSize__u24lambda_u2d0 = externalUrlLoader;
            boolean bl2 = false;
            Integer n = $this$_get_externalSize__u24lambda_u2d0.countRemaining(this.getTopic());
            boolean bl3 = false;
            object = Result.constructor-impl((Object)n);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        externalUrlLoader = object;
        bl = false;
        boolean bl5 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)externalUrlLoader);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl6 = false;
            boolean bl7 = false;
            Throwable throwable3 = throwable2;
            boolean bl8 = false;
            Throwable it = throwable3;
            boolean bl9 = false;
            this.logger.warn(ExceptionsKt.stringify$default(it, "externalSize - ", null, 2, null));
        }
        bl = false;
        Integer n = (Integer)((Object)(Result.isFailure-impl((Object)externalUrlLoader) ? null : externalUrlLoader));
        return n == null ? 0 : n;
    }

    @Override
    public synchronized int getEstimatedExternalSize() {
        Object object;
        ExternalUrlLoader externalUrlLoader = this.loader;
        boolean bl = false;
        try {
            object = Result.Companion;
            ExternalUrlLoader $this$_get_estimatedExternalSize__u24lambda_u2d2 = externalUrlLoader;
            boolean bl2 = false;
            Integer n = $this$_get_estimatedExternalSize__u24lambda_u2d2.estimateRemaining(this.getTopic());
            boolean bl3 = false;
            object = Result.constructor-impl((Object)n);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        externalUrlLoader = object;
        bl = false;
        boolean bl5 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)externalUrlLoader);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl6 = false;
            boolean bl7 = false;
            Throwable throwable3 = throwable2;
            boolean bl8 = false;
            Throwable it = throwable3;
            boolean bl9 = false;
            this.logger.warn(ExceptionsKt.stringify$default(it, "estimatedExternalSize - ", null, 2, null));
        }
        bl = false;
        Integer n = (Integer)((Object)(Result.isFailure-impl((Object)externalUrlLoader) ? null : externalUrlLoader));
        return n == null ? 0 : n;
    }

    @Override
    public synchronized int getEstimatedSize() {
        return this.size() + this.getEstimatedExternalSize();
    }

    public final synchronized int getFreeSlots() {
        return this.capacity - this.cacheImplementation.size();
    }

    public final synchronized boolean isFull() {
        return this.getFreeSlots() == 0;
    }

    @Override
    public synchronized void clear() {
        this.cacheImplementation.clear();
    }

    @Override
    public synchronized void deepClear() {
        this.externalClear();
        this.clear();
    }

    public final synchronized void externalClear() {
        this.loader.deleteAll(this.topic);
    }

    @Override
    public synchronized void load() {
        if (this.getFreeSlots() > 0) {
            this.loadNow();
        }
    }

    @Override
    @NotNull
    public synchronized Collection<UrlAware> loadNow() {
        Collection<UrlAware> collection;
        if (this.getFreeSlots() <= 0) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        try {
            collection = this;
            ++collection.loadCount;
            int cfr_ignored_0 = collection.loadCount;
            collection = this.loader.loadToNow((Collection)this.cacheImplementation, this.getFreeSlots(), this.topic, this.transformer);
        }
        catch (Exception e) {
            this.logger.warn("Failed to load", (Throwable)e);
            boolean bl = false;
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    @Override
    public synchronized void shuffle() {
        List l = CollectionsKt.toMutableList((Collection)this.cacheImplementation);
        this.cacheImplementation.clear();
        List list2 = l;
        boolean bl = false;
        Collections.shuffle(list2);
        this.cacheImplementation.addAll(l);
    }

    @Override
    public synchronized boolean add(@NotNull UrlAware url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.offer(url);
    }

    @Override
    public synchronized boolean addAll(@NotNull Collection<? extends UrlAware> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        if (urls.size() > this.getFreeSlots()) {
            int n = this.getFreeSlots();
            super.addAll(CollectionsKt.take((Iterable)urls, (int)n));
            this.overflow(CollectionsKt.drop((Iterable)urls, (int)n));
        } else {
            super.addAll(urls);
        }
        return true;
    }

    @Override
    public synchronized boolean offer(@NotNull UrlAware url) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (!url.isPersistable() || this.getFreeSlots() > 0) {
            bl = this.cacheImplementation.add(url);
        } else {
            this.overflow(url);
            bl = true;
        }
        return bl;
    }

    @Override
    public synchronized boolean removeIf(@NotNull Predicate<? super UrlAware> filter) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        return this.cacheImplementation.removeIf(filter);
    }

    @Override
    @NotNull
    public synchronized Iterator<UrlAware> iterator() {
        Iterator<UrlAware> iterator = this.refreshIfNecessary().cacheImplementation.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"refreshIfNecessary().cac\u2026Implementation.iterator()");
        return iterator;
    }

    @Override
    @Nullable
    public synchronized UrlAware peek() {
        this.refreshIfNecessary();
        return this.cacheImplementation.peek();
    }

    @Override
    @Nullable
    public synchronized UrlAware poll() {
        this.refreshIfNecessary();
        return this.cacheImplementation.poll();
    }

    @Override
    public synchronized void overflow(@NotNull UrlAware url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.loader.save(url, this.topic);
        AbstractLoadingQueue abstractLoadingQueue = this;
        ++abstractLoadingQueue.savedCount;
        int cfr_ignored_0 = abstractLoadingQueue.savedCount;
    }

    @Override
    public synchronized void overflow(@NotNull List<? extends UrlAware> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        try {
            this.loader.saveAll((Iterable<? extends UrlAware>)urls, this.topic);
            AbstractLoadingQueue abstractLoadingQueue = this;
            abstractLoadingQueue.savedCount += urls.size();
        }
        catch (Exception e) {
            this.logger.warn("Failed to save urls", (Throwable)e);
        }
    }

    private final AbstractLoadingQueue refreshIfNecessary() {
        if (this.cacheImplementation.isEmpty()) {
            this.load();
        }
        return this;
    }
}

