/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.FuzzyProbability;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class FuzzyTracker<T extends Comparable<T>> {
    private Map<T, Double> trackees = new TreeMap<T, Double>();

    public int size() {
        return this.trackees.size();
    }

    public boolean isEmpty() {
        return this.trackees.size() == 0;
    }

    public double remove(T t) {
        Double r = this.trackees.remove(t);
        return r == null ? 0.0 : r;
    }

    public void clear() {
        this.trackees.clear();
    }

    public double get(T t) {
        Double sim = this.trackees.get(t);
        if (sim == null) {
            sim = 0.0;
        }
        return sim;
    }

    public void set(T t, FuzzyProbability p) {
        this.set(t, p.floor());
    }

    public void set(T t, double sim) {
        Double oldValue = this.trackees.get(t);
        if (sim > 1.0) {
            sim = 1.0;
        }
        if (oldValue == null || oldValue < sim) {
            this.trackees.put(t, sim);
        }
    }

    public double inc(T t, double sim) {
        Double oldSim = this.trackees.get(t);
        if (oldSim != null) {
            sim += oldSim.doubleValue();
        }
        if (sim > 1.0) {
            sim = 1.0;
        }
        this.trackees.put(t, sim);
        return sim;
    }

    public double dec(T t, double sim) {
        Double oldSim = this.trackees.get(t);
        if (oldSim != null) {
            sim = oldSim - sim;
        }
        if (sim < FuzzyProbability.STRICTLY_NOT.ceiling()) {
            sim = 0.0;
            this.trackees.remove(t);
        } else {
            this.trackees.put(t, sim);
        }
        return sim;
    }

    public T primaryKey() {
        Comparable lastType = null;
        Double lastSim = 0.0;
        for (Map.Entry<T, Double> entry : this.trackees.entrySet()) {
            if (!(lastSim < entry.getValue())) continue;
            lastSim = entry.getValue();
            lastType = (Comparable)entry.getKey();
        }
        return (T)lastType;
    }

    public Set<T> keySet() {
        return this.trackees.keySet();
    }

    public Set<T> keySet(FuzzyProbability p) {
        HashSet<Comparable> keys = new HashSet<Comparable>();
        for (Comparable key : this.trackees.keySet()) {
            if (!this.is(key, p)) continue;
            keys.add(key);
        }
        return keys;
    }

    public boolean is(T key, FuzzyProbability p) {
        Double sim = this.trackees.get(key);
        if (sim == null) {
            return false;
        }
        FuzzyProbability p2 = FuzzyProbability.of(sim);
        return p2.floor() >= p.floor();
    }

    public boolean maybe(T key) {
        Double p = this.trackees.get(key);
        if (p == null) {
            return false;
        }
        return FuzzyProbability.maybe(p);
    }

    public boolean veryLikely(T key) {
        Double p = this.trackees.get(key);
        if (p == null) {
            return false;
        }
        return FuzzyProbability.veryLikely(p);
    }

    public boolean mustBe(T key) {
        Double p = this.trackees.get(key);
        if (p == null) {
            return false;
        }
        return FuzzyProbability.mustBe(p);
    }

    public boolean certainly(T key) {
        Double p = this.trackees.get(key);
        if (p == null) {
            return false;
        }
        return FuzzyProbability.certainly(p);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Map.Entry<T, Double> entry : this.trackees.entrySet()) {
            if (i++ > 0) {
                sb.append(",");
            }
            sb.append(entry.getKey());
            sb.append(":");
            sb.append(String.format("%1.2f", entry.getValue()));
        }
        return sb.toString();
    }
}

