/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.ResourceLoader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001?B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019J\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\fJ\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\fJ\"\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\fJ\u0010\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u000e\u001a\u00020\fJ$\u0010$\u001a\u0004\u0018\u00010%\"\u0004\b\u0000\u0010&2\u0006\u0010\u000e\u001a\u00020\f2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H&0(J)\u0010)\u001a\u0004\u0018\u00010\u001f2\u0006\u0010!\u001a\u00020\f2\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0+\"\u00020\f\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\u000e\u001a\u00020\fJ)\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\u000e\u001a\u00020\f2\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0+\"\u00020\f\u00a2\u0006\u0002\u0010/J\u001a\u00100\u001a\b\u0012\u0004\u0012\u0002H10(\"\u0004\b\u0000\u001012\u0006\u00102\u001a\u00020\fJ\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\f042\u0006\u0010!\u001a\u00020\fJ\u001c\u00103\u001a\b\u0012\u0004\u0012\u00020\f042\u0006\u0010!\u001a\u00020\f2\u0006\u00105\u001a\u00020\u0010J4\u00103\u001a\b\u0012\u0004\u0012\u00020\f042\b\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\f2\b\b\u0002\u0010#\u001a\u00020\f2\b\b\u0002\u00105\u001a\u00020\u0010H\u0007J\u0014\u00106\u001a\b\u0012\u0004\u0012\u00020\f042\u0006\u00107\u001a\u00020\bJ\u0014\u00108\u001a\b\u0012\u0004\u0012\u00020\f042\u0006\u0010!\u001a\u00020\fJ\u000e\u00109\u001a\u00020\f2\u0006\u0010!\u001a\u00020\fJ\u001e\u0010:\u001a\u00060;j\u0002`<2\u0006\u0010!\u001a\u00020\f2\n\u0010=\u001a\u00060;j\u0002`<J\u000e\u0010>\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n \u0005*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lai/platon/pulsar/common/ResourceLoader;", "", "()V", "classLoader", "Ljava/lang/ClassLoader;", "kotlin.jvm.PlatformType", "lastModifiedTimes", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/file/Path;", "Ljava/time/Instant;", "lineFilter", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "line", "", "getLineFilter", "()Lkotlin/jvm/functions/Function1;", "setLineFilter", "(Lkotlin/jvm/functions/Function1;)V", "logger", "Lorg/slf4j/Logger;", "userClassFactories", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lai/platon/pulsar/common/ResourceLoader$ClassFactory;", "addClassFactory", "", "classFactory", "exists", "getMultiSourceReader", "Ljava/io/Reader;", "stringResource", "fileResource", "namedResource", "resourcePrefix", "getResource", "Ljava/net/URL;", "T", "preferredClassLoader", "Ljava/lang/Class;", "getResourceAsReader", "resourcePrefixes", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/io/Reader;", "getResourceAsStream", "Ljava/io/InputStream;", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/io/InputStream;", "loadUserClass", "Z", "className", "readAllLines", "", "filter", "readAllLinesIfModified", "path", "readAllLinesNoFilter", "readString", "readStringTo", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sb", "removeClassFactory", "ClassFactory", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nResourceLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceLoader.kt\nai/platon/pulsar/common/ResourceLoader\n+ 2 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,282:1\n52#2:283\n52#2:285\n52#2:287\n1#3:284\n1#3:286\n1#3:288\n1#3:289\n1#3:303\n1#3:307\n1#3:308\n766#4:290\n857#4,2:291\n1603#4,9:293\n1855#4:302\n1856#4:304\n1612#4:305\n2634#4:306\n*S KotlinDebug\n*F\n+ 1 ResourceLoader.kt\nai/platon/pulsar/common/ResourceLoader\n*L\n107#1:283\n123#1:285\n129#1:287\n107#1:284\n123#1:286\n129#1:288\n180#1:303\n181#1:307\n179#1:290\n179#1:291,2\n180#1:293,9\n180#1:302\n180#1:304\n180#1:305\n181#1:306\n*E\n"})
public final class ResourceLoader {
    @NotNull
    public static final ResourceLoader INSTANCE = new ResourceLoader();
    private static final Logger logger = LoggerFactory.getLogger(ResourceLoader.class);
    @NotNull
    private static final ConcurrentHashMap<Path, Instant> lastModifiedTimes = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentLinkedDeque<ClassFactory> userClassFactories = new ConcurrentLinkedDeque();
    private static final ClassLoader classLoader;
    @NotNull
    private static Function1<? super String, Boolean> lineFilter;

    private ResourceLoader() {
    }

    @NotNull
    public final Function1<String, Boolean> getLineFilter() {
        return lineFilter;
    }

    public final void setLineFilter(@NotNull Function1<? super String, Boolean> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        lineFilter = function1;
    }

    public final void addClassFactory(@NotNull ClassFactory classFactory) {
        Intrinsics.checkNotNullParameter((Object)classFactory, (String)"classFactory");
        userClassFactories.add(classFactory);
    }

    public final void removeClassFactory(@NotNull ClassFactory classFactory) {
        Intrinsics.checkNotNullParameter((Object)classFactory, (String)"classFactory");
        userClassFactories.remove(classFactory);
    }

    @NotNull
    public final <Z> Class<Z> loadUserClass(@NotNull String className) throws ClassNotFoundException {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        for (ClassFactory classFactory : userClassFactories) {
            if (!classFactory.match(className)) continue;
            try {
                Class<?> userClass = classFactory.loadClass(className);
                if (userClass == null) continue;
                return userClass;
            }
            catch (ClassNotFoundException userClass) {
            }
            catch (Exception e) {
                throw e;
            }
        }
        try {
            Class<?> clazz2 = Class.forName(className);
            Intrinsics.checkNotNull(clazz2, (String)"null cannot be cast to non-null type java.lang.Class<Z of ai.platon.pulsar.common.ResourceLoader.loadUserClass>");
            clazz = clazz2;
        }
        catch (ClassNotFoundException e) {
            Class<?> clazz3 = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            Intrinsics.checkNotNull(clazz3, (String)"null cannot be cast to non-null type java.lang.Class<Z of ai.platon.pulsar.common.ResourceLoader.loadUserClass>");
            Class<?> clazz4 = clazz3;
            clazz = clazz4;
        }
        catch (Error e) {
            throw e;
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public final List<String> readAllLines(@Nullable String stringResource, @NotNull String fileResource, @NotNull String resourcePrefix, boolean filter) {
        Object object;
        block10: {
            block9: {
                List list2;
                Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
                Intrinsics.checkNotNullParameter((Object)resourcePrefix, (String)"resourcePrefix");
                object = this.getMultiSourceReader(stringResource, fileResource, resourcePrefix);
                if (object == null) break block9;
                Reader $this$useLines$iv = object;
                boolean $i$f$useLines = false;
                Closeable closeable = $this$useLines$iv;
                int n = 8192;
                closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
                Throwable throwable = null;
                try {
                    BufferedReader it$iv = (BufferedReader)closeable;
                    boolean bl = false;
                    Sequence seq = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                    boolean bl2 = false;
                    List list3 = filter ? SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)seq, lineFilter)) : SequencesKt.toList((Sequence)seq);
                    list2 = list3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object = list2;
                if (list2 != null) break block10;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public static /* synthetic */ List readAllLines$default(ResourceLoader resourceLoader, String string, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return resourceLoader.readAllLines(string, string2, string3, bl);
    }

    @NotNull
    public final List<String> readAllLines(@NotNull String fileResource) {
        Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
        return this.readAllLines(fileResource, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<String> readAllLines(@NotNull String fileResource, boolean filter) {
        Object object;
        block11: {
            block10: {
                List list2;
                Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
                if (!filter) {
                    return this.readAllLinesNoFilter(fileResource);
                }
                object = this.getResourceAsReader(fileResource, new String[0]);
                if (object == null) break block10;
                Reader $this$useLines$iv = object;
                boolean $i$f$useLines = false;
                Closeable closeable = $this$useLines$iv;
                int n = 8192;
                closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
                Throwable throwable = null;
                try {
                    BufferedReader it$iv = (BufferedReader)closeable;
                    boolean bl = false;
                    Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                    boolean bl2 = false;
                    List list3 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)it, lineFilter));
                    list2 = list3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object = list2;
                if (list2 != null) break block11;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<String> readAllLinesNoFilter(@NotNull String fileResource) {
        Object object;
        block9: {
            block8: {
                List list2;
                Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
                object = this.getResourceAsReader(fileResource, new String[0]);
                if (object == null) break block8;
                Reader $this$useLines$iv = object;
                boolean $i$f$useLines = false;
                Closeable closeable = $this$useLines$iv;
                int n = 8192;
                closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
                Throwable throwable = null;
                try {
                    BufferedReader it$iv = (BufferedReader)closeable;
                    boolean bl = false;
                    Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                    boolean bl2 = false;
                    List list3 = SequencesKt.toList((Sequence)it);
                    list2 = list3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object = list2;
                if (list2 != null) break block9;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final List<String> readAllLinesIfModified(@NotNull Path path) {
        List<String> list2;
        ResourceLoader resourceLoader;
        ResourceLoader resourceLoader2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Instant instant = lastModifiedTimes.getOrDefault(path, Instant.EPOCH);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"lastModifiedTimes.getOrD\u2026ault(path, Instant.EPOCH)");
        Instant lastModified = instant;
        Instant modified = Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
        ResourceLoader it = resourceLoader2 = this;
        boolean bl = false;
        ResourceLoader resourceLoader3 = resourceLoader = modified.compareTo(lastModified) > 0 ? resourceLoader2 : null;
        if (resourceLoader != null) {
            List<String> list3;
            it = resourceLoader;
            boolean bl2 = false;
            List<String> it2 = list3 = Files.readAllLines(path);
            boolean bl3 = false;
            Map map = lastModifiedTimes;
            Intrinsics.checkNotNullExpressionValue((Object)modified, (String)"modified");
            map.put(path, modified);
            list2 = list3;
        } else {
            list2 = null;
        }
        List<String> list4 = list2;
        return list4 == null ? CollectionsKt.emptyList() : list4;
    }

    @NotNull
    public final String readString(@NotNull String fileResource) {
        Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
        String string = this.readStringTo(fileResource, new StringBuilder()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readStringTo(fileResourc\u2026ringBuilder()).toString()");
        return string;
    }

    @NotNull
    public final StringBuilder readStringTo(@NotNull String fileResource, @NotNull StringBuilder sb) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
            Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
            Reader reader = this.getResourceAsReader(fileResource, new String[0]);
            if (reader == null) break block0;
            TextStreamsKt.forEachLine((Reader)reader, (Function1)((Function1)new Function1<String, Unit>(sb){
                final /* synthetic */ StringBuilder $sb;
                {
                    this.$sb = $sb;
                    super(1);
                }

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    StringBuilder stringBuilder = this.$sb.append(it);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder);
                }
            }));
        }
        return sb;
    }

    @Nullable
    public final InputStream getResourceAsStream(@NotNull String name) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            URL uRL = this.getResource(name);
            if (uRL == null) {
                return null;
            }
            URL url = uRL;
            if (logger.isDebugEnabled()) {
                logger.debug("Find resource " + name + " | " + url);
            }
            inputStream = url.openStream();
        }
        catch (IOException e) {
            logger.warn("Failed to read resource {} | {}", (Object)name, (Object)e.getMessage());
            inputStream = null;
        }
        return inputStream;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final InputStream getResourceAsStream(@NotNull String name, String ... resourcePrefixes) {
        void $this$onEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)resourcePrefixes, (String)"resourcePrefixes");
        boolean found = false;
        Iterable $this$filter$iv = ArraysKt.asIterable((Object[])resourcePrefixes);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            InputStream it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            String it2 = (String)element$iv$iv;
            boolean bl3 = false;
            if (INSTANCE.getResourceAsStream(it2 + "/" + name) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            it = (InputStream)element$iv;
            boolean bl5 = false;
            found = true;
        }
        InputStream inputStream = (InputStream)CollectionsKt.firstOrNull((List)((List)iterable));
        if (inputStream == null) {
            inputStream = this.getResourceAsStream(name);
        }
        return inputStream;
    }

    @Nullable
    public final Reader getResourceAsReader(@NotNull String fileResource, String ... resourcePrefixes) {
        InputStreamReader inputStreamReader;
        Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
        Intrinsics.checkNotNullParameter((Object)resourcePrefixes, (String)"resourcePrefixes");
        InputStream inputStream = this.getResourceAsStream(fileResource, Arrays.copyOf(resourcePrefixes, resourcePrefixes.length));
        if (inputStream != null) {
            InputStream it = inputStream;
            boolean bl = false;
            inputStreamReader = new InputStreamReader(it);
        } else {
            inputStreamReader = null;
        }
        return inputStreamReader;
    }

    public final boolean exists(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getResource(name) != null;
    }

    @Nullable
    public final URL getResource(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        URL url = null;
        Iterator<ClassFactory> iterator = userClassFactories.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"userClassFactories.iterator()");
        Iterator<ClassFactory> it = iterator;
        while (url == null && it.hasNext()) {
            url = it.next().getClass().getResource(name);
        }
        URL uRL = url;
        if (uRL == null) {
            uRL = classLoader.getResource(name);
        }
        return uRL;
    }

    @Nullable
    public final <T> URL getResource(@NotNull String name, @NotNull Class<T> preferredClassLoader) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(preferredClassLoader, (String)"preferredClassLoader");
        URL uRL = preferredClassLoader.getResource(name);
        if (uRL == null) {
            uRL = this.getResource(name);
        }
        return uRL;
    }

    @Nullable
    public final Reader getMultiSourceReader(@Nullable String stringResource, @NotNull String fileResource) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
        return this.getMultiSourceReader(stringResource, fileResource, "");
    }

    @Nullable
    public final Reader getMultiSourceReader(@Nullable String stringResource, @NotNull String namedResource, @NotNull String resourcePrefix) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)namedResource, (String)"namedResource");
        Intrinsics.checkNotNullParameter((Object)resourcePrefix, (String)"resourcePrefix");
        Reader reader = null;
        CharSequence charSequence = stringResource;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            reader = new StringReader(stringResource);
        } else if (Files.exists(Paths.get(namedResource, new String[0]), new LinkOption[0])) {
            reader = new FileReader(namedResource);
        } else {
            if (!StringsKt.startsWith$default((String)namedResource, (String)"/", (boolean)false, (int)2, null) && !StringsKt.isBlank((CharSequence)resourcePrefix)) {
                reader = this.getResourceAsReader(resourcePrefix + "/" + namedResource, new String[0]);
            }
            if (reader == null) {
                reader = this.getResourceAsReader(namedResource, new String[0]);
            }
        }
        return reader;
    }

    @JvmOverloads
    @NotNull
    public final List<String> readAllLines(@Nullable String stringResource, @NotNull String fileResource, @NotNull String resourcePrefix) {
        Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
        Intrinsics.checkNotNullParameter((Object)resourcePrefix, (String)"resourcePrefix");
        return ResourceLoader.readAllLines$default(this, stringResource, fileResource, resourcePrefix, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final List<String> readAllLines(@Nullable String stringResource, @NotNull String fileResource) {
        Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
        return ResourceLoader.readAllLines$default(this, stringResource, fileResource, null, false, 12, null);
    }

    static {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ResourceLoader.class.getClassLoader();
        }
        ResourceLoader.classLoader = classLoader;
        lineFilter = lineFilter.1.INSTANCE;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Lai/platon/pulsar/common/ResourceLoader$ClassFactory;", "", "loadClass", "Ljava/lang/Class;", "name", "", "match", "", "pulsar-common"})
    public static interface ClassFactory {
        public boolean match(@NotNull String var1);

        @Nullable
        public Class<?> loadClass(@NotNull String var1) throws ClassNotFoundException;
    }
}

